/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24;

import gov.nasa.giss.gui.JMultiLineLabel;
import gov.nasa.giss.mapping.landmarks.LandmarkList;
import gov.nasa.giss.mars24.M24Globals;
import gov.nasa.giss.mars24.M24PlotPanel;
import gov.nasa.giss.mars24.M24Preferences;
import gov.nasa.giss.mars24.M24TimePanel;
import gov.nasa.giss.mars24.M24Timekeeper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.schmunk.gui.FGConstraint;
import net.schmunk.gui.FlexingGridLayout;

public class M24PanoramaControls
extends JPanel {
    private static final String LOOK_SOUTH_NAME = "Looking South";
    private static final String LOOK_NORTH_NAME = "Looking North";
    private static final String LOOK_EAST_NAME = "Looking East";
    private static final String LOOK_WEST_NAME = "Looking West";
    private static final String PATHVIEW_HIDE = "Hide";
    private static final String PATHVIEW_POSITION = "Position Only";
    private static final String PATHVIEW_PLAIN = "Plain Path";
    private static final String PATHVIEW_TICKS = "Path with Hour Ticks";
    private M24Preferences prefs = M24Globals.getSettings();
    private M24Timekeeper timekeeper = M24Globals.getTimekeeper();
    private M24PlotPanel plotDisplay;
    private M24TimePanel timeDisplay;
    private LandmarkList landmarks;
    private JComboBox pathViewPartsMenu;
    private JComboBox pathViewAngleMenu;
    private JComboBox solPathMenu;
    private JComboBox earthPathMenu;

    public M24PanoramaControls(M24PlotPanel p1, M24TimePanel p2) {
        if (p1 == null) {
            throw new IllegalArgumentException("Plot panel cannot be null");
        }
        this.plotDisplay = p1;
        if (p2 == null) {
            throw new IllegalArgumentException("Time panel cannot be null");
        }
        this.timeDisplay = p2;
        this.landmarks = M24Globals.getLandmarks();
        this.pathViewPartsMenu = new JComboBox();
        this.pathViewPartsMenu.addItem("Graphic and Data");
        this.pathViewPartsMenu.addItem("Graphic Only");
        this.pathViewPartsMenu.addItem("Data Only");
        this.pathViewPartsMenu.setMaximumSize(this.pathViewPartsMenu.getPreferredSize());
        this.pathViewAngleMenu = new JComboBox();
        this.pathViewAngleMenu.addItem(LOOK_SOUTH_NAME);
        this.pathViewAngleMenu.addItem(LOOK_WEST_NAME);
        this.pathViewAngleMenu.addItem(LOOK_NORTH_NAME);
        this.pathViewAngleMenu.addItem(LOOK_EAST_NAME);
        this.pathViewAngleMenu.setMaximumSize(this.pathViewAngleMenu.getPreferredSize());
        this.solPathMenu = new JComboBox();
        this.solPathMenu.addItem(PATHVIEW_POSITION);
        this.solPathMenu.addItem(PATHVIEW_PLAIN);
        this.solPathMenu.addItem(PATHVIEW_TICKS);
        this.solPathMenu.setMaximumSize(this.solPathMenu.getPreferredSize());
        this.earthPathMenu = new JComboBox();
        this.earthPathMenu.addItem(PATHVIEW_HIDE);
        this.earthPathMenu.addItem(PATHVIEW_POSITION);
        this.earthPathMenu.addItem(PATHVIEW_PLAIN);
        this.earthPathMenu.addItem(PATHVIEW_TICKS);
        this.earthPathMenu.setMaximumSize(this.earthPathMenu.getPreferredSize());
        JMultiLineLabel noteLabel = new JMultiLineLabel("Note: Panorama is shown as for the location on Mars specified\nin the 'Time' controls tab.\n \nNote: Calculation of sunrise/set and earthrise/set times\nrequires accurate specification of planetographic latitude\nand longitude, but may still be in error due to atmospheric\nrefraction, local topography, etc.", 2);
        noteLabel.setFont(noteLabel.getFont().deriveFont(2, noteLabel.getFont().getSize() - 2));
        FlexingGridLayout fgl = new FlexingGridLayout(new Dimension(3, 8), 2, 2);
        fgl.setColumnWeight(2, 100.0f);
        fgl.setRowWeight(7, 100.0f);
        this.setLayout(fgl);
        this.setBorder(M24Globals.createPaddedTitleBorder("Panorama Options"));
        this.add((Component)new JLabel("Show: "), new FGConstraint(new Rectangle(0, 0, 1, 1), 0.0, 0.5));
        this.add((Component)this.pathViewPartsMenu, new FGConstraint(new Rectangle(1, 0, 1, 1), 0.0, 0.5));
        this.add(Box.createVerticalStrut(4), new FGConstraint(new Rectangle(0, 1, 1, 1), 0.0, 0.5));
        this.add((Component)new JLabel("Graphic Center: "), new FGConstraint(new Rectangle(0, 2, 1, 1), 0.0, 0.5));
        this.add((Component)this.pathViewAngleMenu, new FGConstraint(new Rectangle(1, 2, 1, 1), 0.0, 0.5));
        this.add((Component)new JLabel("Solar Path: "), new FGConstraint(new Rectangle(0, 3, 1, 1), 0.0, 0.5));
        this.add((Component)this.solPathMenu, new FGConstraint(new Rectangle(1, 3, 1, 1), 0.0, 0.5));
        this.add((Component)new JLabel("Earth Path: "), new FGConstraint(new Rectangle(0, 4, 1, 1), 0.0, 0.5));
        this.add((Component)this.earthPathMenu, new FGConstraint(new Rectangle(1, 4, 1, 1), 0.0, 0.5));
        this.add(Box.createVerticalStrut(4), new FGConstraint(new Rectangle(0, 5, 1, 1), 0.0, 0.5));
        this.add((Component)noteLabel, new FGConstraint(new Rectangle(0, 6, 3, 1), 0.5, 1.0));
        this.addListeners();
    }

    public void setAll() {
        String parts = this.prefs.getString("panorama_layout").toLowerCase();
        if (parts.equals("data only")) {
            this.pathViewPartsMenu.setSelectedIndex(2);
        } else if (parts.equals("graphic only")) {
            this.pathViewPartsMenu.setSelectedIndex(1);
        } else {
            this.pathViewPartsMenu.setSelectedIndex(0);
        }
        String look = this.prefs.getString("panorama_azimuth").toLowerCase();
        if (look.indexOf("north") > -1) {
            this.pathViewAngleMenu.setSelectedItem(LOOK_NORTH_NAME);
        } else if (look.indexOf("east") > -1) {
            this.pathViewAngleMenu.setSelectedItem(LOOK_EAST_NAME);
        } else if (look.indexOf("west") > -1) {
            this.pathViewAngleMenu.setSelectedItem(LOOK_WEST_NAME);
        } else {
            this.pathViewAngleMenu.setSelectedItem(LOOK_SOUTH_NAME);
        }
        this.solPathMenu.setSelectedItem(this.prefs.getString("panorama_markSun"));
        this.earthPathMenu.setSelectedItem(this.prefs.getString("panorama_markEarth"));
    }

    private void addListeners() {
        this.pathViewPartsMenu.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                M24PanoramaControls.this.prefs.set("panorama_layout", (String)M24PanoramaControls.this.pathViewPartsMenu.getSelectedItem());
            }
        });
        this.pathViewAngleMenu.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                String look = ((String)M24PanoramaControls.this.pathViewAngleMenu.getSelectedItem()).toLowerCase();
                if (look.indexOf("north") > -1) {
                    M24PanoramaControls.this.prefs.set("panorama_azimuth", "north");
                } else if (look.indexOf("east") > -1) {
                    M24PanoramaControls.this.prefs.set("panorama_azimuth", "east");
                } else if (look.indexOf("south") > -1) {
                    M24PanoramaControls.this.prefs.set("panorama_azimuth", "south");
                } else if (look.indexOf("west") > -1) {
                    M24PanoramaControls.this.prefs.set("panorama_azimuth", "west");
                } else {
                    M24PanoramaControls.this.prefs.set("panorama_azimuth", "south");
                }
            }
        });
        this.solPathMenu.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                M24PanoramaControls.this.prefs.set("panorama_markSun", M24PanoramaControls.this.solPathMenu.getSelectedItem());
            }
        });
        this.earthPathMenu.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                M24PanoramaControls.this.prefs.set("panorama_markEarth", M24PanoramaControls.this.earthPathMenu.getSelectedItem());
            }
        });
    }
}

