/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24;

import gov.nasa.giss.mars24.M24Globals;
import gov.nasa.giss.mars24.M24Preferences;
import gov.nasa.giss.mars24.M24Timekeeper;
import gov.nasa.giss.mars24.M24TimekeeperEvent;
import gov.nasa.giss.mars24.M24TimekeeperListener;
import gov.nasa.giss.prefs.PreferencesEvent;
import gov.nasa.giss.prefs.PreferencesListener;
import gov.nasa.giss.time.AbstractPlanetTime;
import gov.nasa.giss.time.TimeConstants;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import javax.swing.JComponent;

public class M24OrbitPanel
extends JComponent
implements TimeConstants,
PreferencesListener,
M24TimekeeperListener {
    private static final long REFRESH_INTERVAL = 300000L;
    private static final double MIN_AU = 1.6;
    private static final Color EARTH_COLOR = new Color(153, 153, 255);
    private static final Color MARS_COLOR = Color.red;
    private static final Color SUN_COLOR = Color.yellow;
    private static final Color MARKS_COLOR = Color.white;
    private static final BasicStroke FINE_STROKE = new BasicStroke(0.5f);
    private static final BasicStroke THIN_STROKE = new BasicStroke(1.0f);
    private static final BasicStroke ORBIT_STROKE = new BasicStroke(1.2f);
    private int maxWidth;
    private int maxHeight;
    private int pWidth;
    private int pHeight;
    private int sunX;
    private int sunY;
    private double pixelPerAU;
    private M24Timekeeper timekeeper = M24Globals.getTimekeeper();
    private M24Preferences prefs = M24Globals.getSettings();
    private Font smallFont;
    private Font largeFont;
    private FontMetrics fm;
    private long lastUpdate;

    public M24OrbitPanel(Dimension max) {
        this.maxWidth = max.width;
        this.maxHeight = max.height;
        this.setOpaque(true);
        this.setMaximumSize(max);
        this.setBackground(Color.black);
        this.setDoubleBuffered(true);
        this.timekeeper.addTimekeeperListener(this);
        this.prefs.addSettingsListener(this);
        this.updateSetting("all");
    }

    public void setSize(Dimension d) {
        this.setSize(d);
    }

    public void setSize(int w, int h) {
        super.setSize(w, h);
        this.pWidth = w;
        this.pHeight = h;
        this.sunX = this.pWidth / 2;
        this.sunY = this.pHeight / 2;
        this.pixelPerAU = ((double)this.sunY - 20.0) / 1.6;
        int fheight = Math.max(14, (int)Math.sqrt(this.pHeight)) - 4;
        this.largeFont = new Font("Courier", 0, fheight);
        this.smallFont = new Font("Courier", 0, Math.min(9, fheight * 2 / 3));
    }

    public void paintComponent(Graphics g) {
        if (!this.isVisible()) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setColor(this.getBackground());
        g2d.fillRect(0, 0, this.maxWidth, this.maxHeight);
        g2d.translate(this.sunX, this.sunY);
        Ellipse2D.Float ellipse = new Ellipse2D.Float();
        for (int i = 30; i > 5; i -= 2) {
            float rds = i;
            ellipse.setFrame(-rds, -rds, 2.0f * rds, 2.0f * rds);
            g2d.setColor(new Color(1.0f, 1.0f, 0.0f, 0.08f));
            g2d.fill(ellipse);
        }
        g2d.setColor(Color.white);
        g2d.fillOval(-4, -4, 9, 9);
        this.drawOrbit(g2d, this.timekeeper.getTimeObject(5), Color.pink, "J");
        this.drawOrbit(g2d, this.timekeeper.getTimeObject(4), MARS_COLOR, "M");
        this.drawOrbit(g2d, this.timekeeper.getTimeObject(3), EARTH_COLOR, "E");
        this.drawOrbit(g2d, this.timekeeper.getTimeObject(2), Color.yellow, "V");
        this.drawOrbit(g2d, this.timekeeper.getTimeObject(1), Color.white, "m");
        g2d.translate(-this.sunX, -this.sunY);
    }

    private void drawOrbit(Graphics2D g2d, AbstractPlanetTime t, Color color, String label) {
        double peri = t.getHeliocentricLongitudeAtPerihelion(true);
        double periRad = peri * (Math.PI / 180);
        double cosPeri = Math.cos(periRad);
        double sinPeri = Math.sin(periRad);
        double pDist = t.getDistanceToSun(3, 0.0) * this.pixelPerAU;
        double aDist = t.getDistanceToSun(3, 180.0) * this.pixelPerAU;
        double e = t.getEccentricity();
        double semimajor = 0.5 * (pDist + aDist);
        double semiminor = semimajor * Math.sqrt(1.0 - e * e);
        Ellipse2D.Double ellipse = new Ellipse2D.Double(0.0, 0.0, pDist + aDist, 2.0 * semiminor);
        g2d.setColor(color);
        g2d.setStroke(ORBIT_STROKE);
        g2d.rotate(-periRad);
        g2d.translate(-pDist, -semiminor);
        g2d.draw(ellipse);
        g2d.translate(pDist, semiminor);
        g2d.rotate(periRad);
        g2d.setColor(MARKS_COLOR);
        g2d.setStroke(THIN_STROKE);
        g2d.setFont(this.smallFont);
        this.fm = g2d.getFontMetrics();
        double shortR = pDist - 5.0;
        double longR = pDist + 5.0;
        g2d.drawLine(-((int)(cosPeri * shortR)), (int)(sinPeri * shortR), -((int)(cosPeri * longR)), (int)(sinPeri * longR));
        if (sinPeri > 0.0) {
            g2d.drawString("p", -((int)(cosPeri * longR)), (int)(sinPeri * longR) + this.fm.getHeight() - 3);
        } else {
            g2d.drawString("p", -((int)(cosPeri * shortR)), (int)(sinPeri * shortR) + this.fm.getHeight() - 3);
        }
        shortR = aDist - 2.0;
        longR = aDist + 2.0;
        g2d.drawLine((int)(cosPeri * shortR), -((int)(sinPeri * shortR)), (int)(cosPeri * longR), -((int)(sinPeri * longR)));
        g2d.setColor(MARKS_COLOR);
        g2d.setStroke(THIN_STROKE);
        g2d.setFont(this.smallFont);
        this.fm = g2d.getFontMetrics();
        double ve = t.getVernalEquinox();
        for (int i = 0; i < 4; ++i) {
            double angleDeg = ve + (double)i * 90.0;
            double angleRad = Math.toRadians(angleDeg);
            double cosAngle = Math.cos(angleRad);
            double sinAngle = Math.sin(angleRad);
            double r = t.getDistanceToSun(3, angleDeg - peri) * this.pixelPerAU;
            if (i == 0) {
                shortR = r - 5.0;
                longR = r + 5.0;
            } else {
                shortR = r - 2.0;
                longR = r + 2.0;
            }
            g2d.drawLine(-((int)(cosAngle * shortR)), (int)(sinAngle * shortR), -((int)(cosAngle * longR)), (int)(sinAngle * longR));
            if (i != 0) continue;
            g2d.drawString("ve", -((int)(cosAngle * shortR)) + 2, (int)(sinAngle * shortR) + this.fm.getHeight());
        }
        double r = t.getDistanceToSun(3) * this.pixelPerAU;
        double rad = (t.getHeliocentricLongitude() + 180.0) * (Math.PI / 180);
        int x = (int)(r * Math.cos(rad));
        int y = (int)(r * Math.sin(rad));
        g2d.setFont(this.largeFont);
        this.fm = g2d.getFontMetrics();
        g2d.setColor(color);
        g2d.fillOval(-x - 4, y - 4, 8, 8);
        g2d.setStroke(FINE_STROKE);
        g2d.setColor(Color.white);
        g2d.drawOval(-x - 4, y - 4, 8, 8);
        if (label == null || label.equals("")) {
            return;
        }
        g2d.setColor(color);
        if (x * y < 0) {
            g2d.drawString(label, -x + 4, y - 2 + this.fm.getHeight());
        } else {
            g2d.drawString(label, -x + 6, y - 2);
        }
    }

    public String getName() {
        return "Orbital Positions of the Inner Planets";
    }

    public void timeChanged(M24TimekeeperEvent e) {
        if (!this.isVisible()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.lastUpdate < 300000L) {
            return;
        }
        this.repaint();
        this.lastUpdate = now;
    }

    public void timeReset(M24TimekeeperEvent e) {
        this.lastUpdate = 0L;
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public void siteChanged(M24TimekeeperEvent e) {
    }

    public void formatChanged(M24TimekeeperEvent e) {
    }

    public void settingChanged(PreferencesEvent e) {
        this.updateSetting(e.getName());
    }

    private void updateSetting(String pname) {
        this.lastUpdate = 0L;
        if (this.isVisible()) {
            this.repaint();
        }
    }
}

