/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24;

import gov.nasa.giss.gui.QuickBox;
import gov.nasa.giss.mapping.landmarks.LandmarkList;
import gov.nasa.giss.mars24.M24Globals;
import gov.nasa.giss.mars24.M24LandmarkMenu;
import gov.nasa.giss.mars24.M24PlotPanel;
import gov.nasa.giss.mars24.M24Preferences;
import gov.nasa.giss.mars24.M24TimePanel;
import gov.nasa.giss.mars24.M24Timekeeper;
import gov.nasa.giss.text.LatitudeDocument;
import gov.nasa.giss.text.LongitudeDocument;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.schmunk.gui.FGConstraint;
import net.schmunk.gui.FlexingGridLayout;

public class M24MarsTimeControls
extends JPanel {
    private static final String LMST_NAME = "Local Mean Solar Time (LMST)";
    private static final String LTST_NAME = "Local True Solar Time (LTST)";
    private static final String LMZT_NAME = "Local Mean Zonal Time";
    private static final String MER_SPIRIT = "MER-A Spirit";
    private static final String MER_OPPORTUNITY = "MER-B Opportunity";
    private static final String BOTH_MER = "Both MER-A and MER-B";
    private static final String PATHFINDER = "Mars Pathfinder";
    private static final String[] MISSION_CHOICES = new String[]{"MER-A Spirit", "MER-B Opportunity", "Both MER-A and MER-B", "Mars Pathfinder"};
    private M24Preferences prefs;
    private M24Timekeeper timekeeper;
    private M24PlotPanel plotDisplay;
    private M24TimePanel timeDisplay;
    private LandmarkList landmarks;
    private JRadioButton showMissionTimeButton;
    private JRadioButton showSpotTimeButton;
    private JRadioButton useSpotByLonLatButton;
    private JRadioButton useSpotByLandmarkButton;
    private JComboBox spotLandmarkMenu;
    private JTextField spotLonTF;
    private JTextField spotLatTF;
    private JComboBox timeFormMenu;
    private JComboBox missionMenu;
    private JCheckBox missionYearCB;

    public M24MarsTimeControls(M24PlotPanel p1, M24TimePanel p2) {
        if (p1 == null) {
            throw new IllegalArgumentException("Plot panel cannot be null");
        }
        if (p2 == null) {
            throw new IllegalArgumentException("Time panel cannot be null");
        }
        this.plotDisplay = p1;
        this.timeDisplay = p2;
        this.prefs = M24Globals.getSettings();
        this.timekeeper = M24Globals.getTimekeeper();
        this.landmarks = M24Globals.getLandmarks();
        this.showMissionTimeButton = new JRadioButton("");
        this.showSpotTimeButton = new JRadioButton("");
        ButtonGroup methodGroup = new ButtonGroup();
        methodGroup.add(this.showMissionTimeButton);
        methodGroup.add(this.showSpotTimeButton);
        this.missionMenu = new JComboBox<String>(MISSION_CHOICES);
        QuickBox missionBox = QuickBox.createHorizontalBox(2, new Component[]{new JLabel("Mission time for "), this.missionMenu});
        this.missionYearCB = new JCheckBox("Format mission date as Y-DDD", false);
        this.spotLonTF = new JTextField("0.0", 5);
        this.spotLatTF = new JTextField("0.0", 5);
        this.spotLonTF.setDocument(new LongitudeDocument());
        this.spotLatTF.setDocument(new LatitudeDocument());
        this.useSpotByLandmarkButton = new JRadioButton("", false);
        this.useSpotByLonLatButton = new JRadioButton("", false);
        ButtonGroup spotGroup = new ButtonGroup();
        spotGroup.add(this.useSpotByLandmarkButton);
        spotGroup.add(this.useSpotByLonLatButton);
        this.spotLandmarkMenu = new M24LandmarkMenu(false);
        this.spotLonTF.setMaximumSize(this.spotLonTF.getPreferredSize());
        this.spotLatTF.setMaximumSize(this.spotLatTF.getPreferredSize());
        this.timeFormMenu = new JComboBox<String>(new String[]{LMST_NAME, LTST_NAME, LMZT_NAME});
        QuickBox landmarkBox = QuickBox.createHorizontalBox(2, new Component[]{this.useSpotByLandmarkButton, new JLabel("Landmark: "), this.spotLandmarkMenu});
        QuickBox lonlatBox = QuickBox.createHorizontalBox(2, new Component[]{this.useSpotByLonLatButton, new JLabel("Lon. "), this.spotLonTF, new JLabel("\u00b0W, lat. "), this.spotLatTF, new JLabel("\u00b0N ")});
        QuickBox formBox = QuickBox.createHorizontalBox(2, new Component[]{new JLabel("Format as ", 4), this.timeFormMenu});
        JPanel tsPanel = new JPanel();
        tsPanel.setLayout(new BoxLayout(tsPanel, 1));
        tsPanel.add(landmarkBox);
        tsPanel.add(Box.createVerticalStrut(6));
        tsPanel.add(lonlatBox);
        tsPanel.add(formBox);
        FlexingGridLayout fgl = new FlexingGridLayout(new Dimension(2, 6), 2, 2);
        fgl.setColumnWeight(0, 0.0f);
        fgl.setColumnWeight(1, 1.0f);
        this.setLayout(fgl);
        this.setBorder(M24Globals.STANDARD_BORDER);
        this.add((Component)new JLabel("Display:"), new FGConstraint(new Rectangle(0, 0, 2, 1), 0.0, 0.5));
        this.add((Component)this.showMissionTimeButton, new FGConstraint(new Rectangle(0, 1, 1, 1), 0.0, 0.5));
        this.add((Component)missionBox, new FGConstraint(new Rectangle(1, 1, 1, 1), 0.0, 0.5));
        this.add((Component)this.missionYearCB, new FGConstraint(new Rectangle(1, 2, 1, 1), 0.0, 0.5));
        this.add((Component)this.showSpotTimeButton, new FGConstraint(new Rectangle(0, 3, 1, 1), 0.0, 0.5));
        this.add((Component)new JLabel("Local time at"), new FGConstraint(new Rectangle(1, 3, 1, 1), 0.0, 0.5));
        this.add((Component)tsPanel, new FGConstraint(new Rectangle(1, 4, 1, 1), 0.0, 0.5));
        this.add(Box.createVerticalGlue(), new FGConstraint(new Rectangle(0, 5, 2, 1), 0.0, 0.5));
        this.addListeners();
    }

    private void addListeners() {
        ActionListener timeButtonAL = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (M24MarsTimeControls.this.showMissionTimeButton.isSelected()) {
                    if (M24MarsTimeControls.this.missionMenu.getSelectedItem() == M24MarsTimeControls.MER_SPIRIT) {
                        M24MarsTimeControls.this.prefs.set("marsTime_method", "MERA");
                    } else if (M24MarsTimeControls.this.missionMenu.getSelectedItem() == M24MarsTimeControls.MER_OPPORTUNITY) {
                        M24MarsTimeControls.this.prefs.set("marsTime_method", "MERB");
                    } else if (M24MarsTimeControls.this.missionMenu.getSelectedItem() == M24MarsTimeControls.BOTH_MER) {
                        M24MarsTimeControls.this.prefs.set("marsTime_method", "MERA_MERB");
                    } else if (M24MarsTimeControls.this.missionMenu.getSelectedItem() == M24MarsTimeControls.PATHFINDER) {
                        M24MarsTimeControls.this.prefs.set("marsTime_method", "MPF");
                    }
                } else if (M24MarsTimeControls.this.showSpotTimeButton.isSelected()) {
                    M24MarsTimeControls.this.prefs.set("marsTime_method", "local");
                }
            }
        };
        this.showMissionTimeButton.addActionListener(timeButtonAL);
        this.showSpotTimeButton.addActionListener(timeButtonAL);
        this.missionMenu.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (M24MarsTimeControls.this.showMissionTimeButton.isSelected()) {
                    if (M24MarsTimeControls.this.missionMenu.getSelectedItem() == M24MarsTimeControls.MER_SPIRIT) {
                        M24MarsTimeControls.this.prefs.set("marsTime_method", "MERA");
                    } else if (M24MarsTimeControls.this.missionMenu.getSelectedItem() == M24MarsTimeControls.MER_OPPORTUNITY) {
                        M24MarsTimeControls.this.prefs.set("marsTime_method", "MERB");
                    } else if (M24MarsTimeControls.this.missionMenu.getSelectedItem() == M24MarsTimeControls.BOTH_MER) {
                        M24MarsTimeControls.this.prefs.set("marsTime_method", "MERA_MERB");
                    } else if (M24MarsTimeControls.this.missionMenu.getSelectedItem() == M24MarsTimeControls.PATHFINDER) {
                        M24MarsTimeControls.this.prefs.set("marsTime_method", "MPF");
                    }
                }
            }
        });
        ActionListener timeSpotTypeAL = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (M24MarsTimeControls.this.useSpotByLonLatButton.isSelected()) {
                    M24MarsTimeControls.this.prefs.set("marsTime_spotType", "lonlat");
                } else if (M24MarsTimeControls.this.useSpotByLandmarkButton.isSelected()) {
                    M24MarsTimeControls.this.prefs.set("marsTime_spotType", "landmark");
                }
            }
        };
        this.useSpotByLandmarkButton.addActionListener(timeSpotTypeAL);
        this.useSpotByLonLatButton.addActionListener(timeSpotTypeAL);
        ActionListener timeSpotFieldAL = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                double dx = 0.0;
                try {
                    String val = ((JTextField)e.getSource()).getText();
                    dx = val.equals("-") || val.equals(".") ? 0.0 : Double.parseDouble(val);
                }
                catch (Exception exc) {
                    M24MarsTimeControls.this.getToolkit().beep();
                    ((JTextField)e.getSource()).requestFocus();
                    return;
                }
                if (e.getSource() == M24MarsTimeControls.this.spotLonTF) {
                    M24MarsTimeControls.this.prefs.setDouble("marsTime_spotLon", dx);
                } else if (e.getSource() == M24MarsTimeControls.this.spotLatTF) {
                    M24MarsTimeControls.this.prefs.setDouble("marsTime_spotLat", dx);
                }
            }
        };
        this.spotLonTF.addActionListener(timeSpotFieldAL);
        this.spotLatTF.addActionListener(timeSpotFieldAL);
        FocusListener timeSpotFieldFL = new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                double dx = 0.0;
                try {
                    String val = ((JTextField)e.getSource()).getText();
                    dx = val.equals("-") || val.equals(".") ? 0.0 : Double.parseDouble(val);
                }
                catch (Exception exc) {
                    M24MarsTimeControls.this.getToolkit().beep();
                    ((JTextField)e.getSource()).requestFocus();
                    return;
                }
                if (e.getSource() == M24MarsTimeControls.this.spotLonTF) {
                    M24MarsTimeControls.this.prefs.setDouble("marsTime_spotLon", dx);
                } else if (e.getSource() == M24MarsTimeControls.this.spotLatTF) {
                    M24MarsTimeControls.this.prefs.setDouble("marsTime_spotLat", dx);
                }
            }
        };
        this.spotLonTF.addFocusListener(timeSpotFieldFL);
        this.spotLatTF.addFocusListener(timeSpotFieldFL);
        this.timeFormMenu.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                M24MarsTimeControls.this.prefs.set("marsTime_format", (String)M24MarsTimeControls.this.timeFormMenu.getSelectedItem());
            }
        });
        this.spotLandmarkMenu.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                M24MarsTimeControls.this.prefs.set("marsTime_spotLandmark", (String)M24MarsTimeControls.this.spotLandmarkMenu.getSelectedItem());
            }
        });
    }

    public void setAll() {
        String mMethod = this.prefs.getString("marsTime_method");
        if (mMethod == null) {
            mMethod = "local";
        }
        if ((mMethod = mMethod.toLowerCase()).indexOf("local") > -1) {
            this.showSpotTimeButton.setSelected(true);
        } else {
            this.showMissionTimeButton.setSelected(true);
            if (mMethod.equals("mera_merb")) {
                this.missionMenu.setSelectedItem(BOTH_MER);
            } else if (mMethod.equals("merb")) {
                this.missionMenu.setSelectedItem(MER_OPPORTUNITY);
            } else if (mMethod.equals("mera")) {
                this.missionMenu.setSelectedItem(MER_SPIRIT);
            } else if (mMethod.equals("mpf")) {
                this.missionMenu.setSelectedItem(PATHFINDER);
            } else {
                this.missionMenu.setSelectedItem(MER_SPIRIT);
            }
        }
        String timeform = this.prefs.getString("marsTime_format").toLowerCase();
        if (timeform == null) {
            timeform = "mean solar";
        }
        if (timeform.indexOf("mean solar") > -1) {
            this.timeFormMenu.setSelectedItem(LMST_NAME);
        } else if (timeform.indexOf("true solar") > -1) {
            this.timeFormMenu.setSelectedItem(LTST_NAME);
        } else if (timeform.indexOf("zonal") > -1) {
            this.timeFormMenu.setSelectedItem(LMZT_NAME);
        } else {
            this.timeFormMenu.setSelectedItem(LMST_NAME);
        }
        String spotType = this.prefs.getString("marsTime_spotType").toLowerCase();
        if (spotType == null) {
            spotType = "landmark";
        }
        this.useSpotByLonLatButton.setSelected(spotType.equals("lonlat"));
        this.useSpotByLandmarkButton.setSelected(!spotType.equals("lonlat"));
        this.spotLandmarkMenu.setSelectedItem(this.prefs.getString("marsTime_spotLandmark"));
        try {
            double lon;
            for (lon = this.prefs.getDouble("marsTime_spotLon"); lon < 0.0; lon += 360.0) {
            }
            while (lon > 360.0) {
                lon -= 360.0;
            }
            this.spotLonTF.setText(M24Globals.FORMAT_X2.format(lon));
        }
        catch (Exception exc) {
            this.spotLonTF.setText("0.0");
        }
        try {
            double lat = this.prefs.getDouble("marsTime_spotLat");
            if (lat < -90.0) {
                lat = -90.0;
            }
            if (lat > 90.0) {
                lat = 90.0;
            }
            this.spotLatTF.setText(M24Globals.FORMAT_X2.format(lat));
        }
        catch (Exception exc) {
            this.spotLatTF.setText("0.0");
        }
    }

    public void setTimeSpot(double lon, double lat) {
        while (lon < 0.0) {
            lon += 360.0;
        }
        while (lon > 360.0) {
            lon -= 360.0;
        }
        if (lat < -90.0) {
            lat = -90.0;
        }
        if (lat > 90.0) {
            lat = 90.0;
        }
        this.spotLonTF.setText(M24Globals.FORMAT_X2.format(lon));
        this.spotLatTF.setText(M24Globals.FORMAT_X2.format(lat));
    }
}

