/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24;

import gov.nasa.giss.mapping.landmarks.Landmark;
import gov.nasa.giss.mapping.landmarks.LandmarkList;
import gov.nasa.giss.mars24.M24Globals;
import gov.nasa.giss.mars24.M24Preferences;
import gov.nasa.giss.mars24.M24Timekeeper;
import gov.nasa.giss.mars24.M24TimekeeperEvent;
import gov.nasa.giss.mars24.M24TimekeeperListener;
import gov.nasa.giss.prefs.PreferencesEvent;
import gov.nasa.giss.prefs.PreferencesListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class M24LandmarkTable
extends JScrollPane
implements PreferencesListener,
M24TimekeeperListener {
    private static final long REFRESH_INTERVAL = 30000L;
    private static final DefaultTableCellRenderer LEFT_STRING_RENDERER = new DefaultTableCellRenderer();
    private static final DefaultTableCellRenderer CENTER_STRING_RENDERER = new DefaultTableCellRenderer();
    private static final DefaultTableCellRenderer RIGHT_STRING_RENDERER = new DefaultTableCellRenderer();
    private JTable table;
    private LandmarkList landmarks;
    private M24Timekeeper timekeeper;
    private DefaultTableModel tableModel;
    private M24Preferences prefs = M24Globals.getSettings();
    private long lastUpdate = 0L;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;

    M24LandmarkTable() {
        this.landmarks = M24Globals.getLandmarks();
        this.timekeeper = M24Globals.getTimekeeper();
        this.tableModel = new DefaultTableModel(){

            public int getColumnCount() {
                return 5;
            }

            public int getRowCount() {
                try {
                    return M24LandmarkTable.this.landmarks.count() + 2;
                }
                catch (Exception exc) {
                    return 0;
                }
            }

            public Class getColumnClass(int col) {
                switch (col) {
                    case 0: {
                        return class$java$lang$Boolean == null ? (class$java$lang$Boolean = M24LandmarkTable.class$("java.lang.Boolean")) : class$java$lang$Boolean;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        return class$java$lang$String == null ? (class$java$lang$String = M24LandmarkTable.class$("java.lang.String")) : class$java$lang$String;
                    }
                }
                return class$java$lang$String == null ? (class$java$lang$String = M24LandmarkTable.class$("java.lang.String")) : class$java$lang$String;
            }

            public String getColumnName(int col) {
                switch (col) {
                    case 0: {
                        return "Mark";
                    }
                    case 1: {
                        return "ID";
                    }
                    case 2: {
                        return "Name";
                    }
                    case 3: {
                        return "Lon W";
                    }
                    case 4: {
                        return "Lat N";
                    }
                }
                return "";
            }

            public Object getValueAt(int row, int col) {
                if (row == 0) {
                    switch (col) {
                        case 0: {
                            try {
                                return (Boolean)M24LandmarkTable.this.prefs.get("sunclock_markSun");
                            }
                            catch (Exception exc) {
                                return Boolean.FALSE;
                            }
                        }
                        case 1: {
                            return "";
                        }
                        case 2: {
                            return "Subsolar Point";
                        }
                        case 3: {
                            M24Timekeeper m24Timekeeper = M24LandmarkTable.this.timekeeper;
                            M24LandmarkTable.this.timekeeper;
                            return M24Globals.FORMAT_X1.format(m24Timekeeper.getTimeObject(4).getSubsolarLongitude(1));
                        }
                        case 4: {
                            M24Timekeeper m24Timekeeper = M24LandmarkTable.this.timekeeper;
                            M24LandmarkTable.this.timekeeper;
                            return M24Globals.FORMAT_X1.format(m24Timekeeper.getTimeObject(4).getSolarDeclination(1));
                        }
                    }
                    return "";
                }
                if (row == 1) {
                    switch (col) {
                        case 0: {
                            try {
                                return (Boolean)M24LandmarkTable.this.prefs.get("sunclock_markEarth");
                            }
                            catch (Exception exc) {
                                return Boolean.FALSE;
                            }
                        }
                        case 1: {
                            return "";
                        }
                        case 2: {
                            return "Sub-Earth Point";
                        }
                        case 3: {
                            M24Timekeeper m24Timekeeper = M24LandmarkTable.this.timekeeper;
                            M24LandmarkTable.this.timekeeper;
                            return M24Globals.FORMAT_X1.format(m24Timekeeper.getTimeObject(4).getSubEarthPoint(1).getX());
                        }
                        case 4: {
                            M24Timekeeper m24Timekeeper = M24LandmarkTable.this.timekeeper;
                            M24LandmarkTable.this.timekeeper;
                            return M24Globals.FORMAT_X1.format(m24Timekeeper.getTimeObject(4).getSubEarthPoint(1).getY());
                        }
                    }
                    return "";
                }
                int lindex = row - 2;
                Landmark l = M24LandmarkTable.this.landmarks.get(lindex);
                switch (col) {
                    case 0: {
                        return new Boolean(l.isMarked());
                    }
                    case 1: {
                        return l.getCode();
                    }
                    case 2: {
                        return l.getName();
                    }
                    case 3: {
                        return M24Globals.FORMAT_X1.format(l.getLongitude());
                    }
                    case 4: {
                        return M24Globals.FORMAT_X1.format(l.getLatitude());
                    }
                }
                return "";
            }

            public boolean isCellEditable(int row, int col) {
                return col == 0;
            }

            public void setValueAt(Object value, int row, int col) {
                if (col > 0) {
                    return;
                }
                if (row == 0) {
                    M24LandmarkTable.this.prefs.set("sunclock_markSun", (Boolean)value);
                    return;
                }
                if (row == 1) {
                    M24LandmarkTable.this.prefs.set("sunclock_markEarth", (Boolean)value);
                    return;
                }
                int lindex = row - 2;
                Landmark l = M24LandmarkTable.this.landmarks.get(lindex);
                l.setMarked((Boolean)value);
            }

            public void sortByColumn(int col) {
            }

            public void addBlankItemAt(int row) {
            }

            public Object removeItemAt(int row) {
                return null;
            }
        };
        this.table = new JTable(this.tableModel);
        this.table.setOpaque(false);
        TableColumnModel tcm = this.table.getColumnModel();
        tcm.getColumn(1).setCellRenderer(CENTER_STRING_RENDERER);
        tcm.getColumn(2).setCellRenderer(LEFT_STRING_RENDERER);
        tcm.getColumn(3).setCellRenderer(RIGHT_STRING_RENDERER);
        tcm.getColumn(4).setCellRenderer(RIGHT_STRING_RENDERER);
        JTableHeader jth = this.table.getTableHeader();
        jth.setReorderingAllowed(false);
        this.table.setAutoResizeMode(2);
        this.table.setCellSelectionEnabled(true);
        this.table.setGridColor(new Color(0xEEEEEE));
        this.table.setSelectionMode(1);
        this.table.setShowGrid(true);
        TableModel model = this.table.getModel();
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            TableColumn col = tcm.getColumn(i);
            int width = 0;
            TableCellRenderer tcr = col.getHeaderRenderer();
            if (tcr == null) {
                tcr = jth.getDefaultRenderer();
            }
            Component c = tcr.getTableCellRendererComponent(this.table, col.getHeaderValue(), false, false, 0, 0);
            width = c.getPreferredSize().width;
            for (int r = 0; r < this.table.getRowCount(); ++r) {
                tcr = this.table.getCellRenderer(r, i);
                c = tcr.getTableCellRendererComponent(this.table, this.table.getValueAt(r, i), false, false, r, i);
                width = Math.max(width, c.getPreferredSize().width);
            }
            col.setPreferredWidth(width);
        }
        this.setViewportView(this.table);
        this.setVerticalScrollBarPolicy(22);
        this.setHorizontalScrollBarPolicy(32);
        this.setOpaque(false);
        this.prefs.addSettingsListener(this);
        this.updateSetting("all");
        if (M24Globals.isAppletContext()) {
            this.setMaximumSize(new Dimension(240, 300));
            this.setPreferredSize(new Dimension(240, 220));
            this.setMinimumSize(new Dimension(240, 160));
        } else {
            this.setMaximumSize(new Dimension(320, 300));
            this.setPreferredSize(new Dimension(320, 220));
            this.setMinimumSize(new Dimension(240, 160));
        }
        this.timekeeper.addTimekeeperListener(this);
    }

    public void repaint() {
        super.repaint();
        this.lastUpdate = System.currentTimeMillis();
    }

    public void paintChildren(Graphics g) {
        this.tableModel.fireTableDataChanged();
        super.paintChildren(g);
    }

    public void settingChanged(PreferencesEvent e) {
        this.updateSetting(e.getName());
    }

    private void updateSetting(String pname) {
    }

    public void timeChanged(M24TimekeeperEvent e) {
        if (!this.isVisible()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.lastUpdate < 30000L) {
            return;
        }
        this.repaint();
        this.lastUpdate = now;
    }

    public void timeReset(M24TimekeeperEvent e) {
        this.lastUpdate = 0L;
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public void siteChanged(M24TimekeeperEvent e) {
    }

    public void formatChanged(M24TimekeeperEvent e) {
    }

    static {
        CENTER_STRING_RENDERER.setHorizontalAlignment(0);
        RIGHT_STRING_RENDERER.setHorizontalAlignment(4);
    }
}

