/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24;

import gov.nasa.giss.mars24.M24Globals;
import gov.nasa.giss.mars24.M24Menubar;
import gov.nasa.giss.mars24.M24Preferences;
import gov.nasa.giss.mars24.M24WindowMenu;
import java.applet.AppletContext;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class M24HelpFrame
extends JFrame
implements HyperlinkListener {
    private static Hashtable framesHash = new Hashtable(3);
    private static String[] browserExecs = null;
    private static M24Preferences prefs;
    private String fname;
    private static final String WINDOWS_DLL = "rundll32 url.dll,FileProtocolHandler {0}";

    public static M24HelpFrame findFrame(String which) {
        M24HelpFrame f;
        AppletContext ac = M24Globals.getAppletContext();
        if (ac != null) {
            try {
                ac.showDocument(new URL("http://www.giss.nasa.gov/tools/mars24/resources/help/" + which + ".html"), "m24help");
                return null;
            }
            catch (Exception exc) {
                // empty catch block
            }
        }
        if ((f = (M24HelpFrame)framesHash.get(which)) != null) {
            return f;
        }
        if (!(which.equals("guide") || which.equals("notes") || which.equals("faq") || which.equals("algorithm"))) {
            throw new IllegalArgumentException("Unrecognized help doc '" + which + "'");
        }
        try {
            f = new M24HelpFrame(which);
            framesHash.put(which, f);
            return f;
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    private M24HelpFrame(String fn) throws IOException {
        Rectangle rr;
        if (fn == null) {
            throw new IllegalArgumentException("Null passed for help file ID.");
        }
        if (prefs == null) {
            prefs = M24Globals.getSettings();
        }
        this.fname = fn;
        this.setName(this.fname);
        if (this.fname.equals("notes")) {
            this.setTitle("Mars24 - Notes about Mars Time");
        } else if (this.fname.equals("faq")) {
            this.setTitle("Mars24 - Frequently Asked Questions");
        } else if (this.fname.equals("algorithm")) {
            this.setTitle("Mars24 - Algorithm and Worked Examples");
        } else {
            this.setTitle("Mars24 - User's Guide");
        }
        this.setResizable(true);
        this.setDefaultCloseOperation(1);
        this.setJMenuBar(new M24Menubar(this));
        JEditorPane jep = new JEditorPane(M24HelpFrame.class.getResource("resources/help/" + this.fname + ".html"));
        jep.setEditable(false);
        jep.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        jep.addHyperlinkListener(this);
        JScrollPane sp = new JScrollPane(jep);
        if (M24Globals.isMacintosh()) {
            sp.setVerticalScrollBarPolicy(22);
            sp.setHorizontalScrollBarPolicy(32);
        }
        if ((rr = M24Globals.getMainScreenBounds()) == null) {
            sp.setPreferredSize(new Dimension(400, 460));
            sp.setPreferredSize(new Dimension(400, 300));
        } else {
            sp.setPreferredSize(new Dimension(Math.min(rr.width, 540), rr.height - 80));
            sp.setMinimumSize(new Dimension(Math.min(rr.width - 80, 400), 300));
        }
        sp.setMinimumSize(sp.getPreferredSize());
        sp.setBorder(null);
        this.getContentPane().add(sp);
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent exc) {
                ((M24WindowMenu)((M24Menubar)M24HelpFrame.this.getJMenuBar()).getMenu("Window")).update();
                if (M24HelpFrame.this.fname.equals("notes")) {
                    prefs.setBoolean("help_notesVisible", true);
                } else if (M24HelpFrame.this.fname.equals("faq")) {
                    prefs.setBoolean("help_faqVisible", true);
                } else {
                    prefs.setBoolean("help_guideVisible", true);
                }
            }

            public void windowClosing(WindowEvent e) {
                if (M24HelpFrame.this.fname.equals("notes")) {
                    prefs.setBoolean("help_notesVisible", false);
                    prefs.setLastFrameClosed("notes");
                } else if (M24HelpFrame.this.fname.equals("faq")) {
                    prefs.setBoolean("help_faqVisible", false);
                    prefs.setLastFrameClosed("faq");
                } else {
                    prefs.setBoolean("help_guideVisible", false);
                    prefs.setLastFrameClosed("guide");
                }
            }
        });
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
            return;
        }
        JEditorPane pane = (JEditorPane)e.getSource();
        if (e instanceof HTMLFrameHyperlinkEvent) {
            return;
        }
        try {
            int slash;
            String s = e.getURL().toString();
            if (s.startsWith("http://")) {
                if (M24Globals.isApplicationContext()) {
                    M24HelpFrame.displayURL(e.getURL());
                } else {
                    M24Globals.getAppletContext().showDocument(e.getURL(), "m24help");
                }
            } else if (s.startsWith("jar:file:") && (slash = s.lastIndexOf("/")) > -1) {
                if (s.regionMatches(slash + 1, this.fname, 0, this.fname.length())) {
                    pane.setPage(e.getURL());
                } else {
                    int dot = s.indexOf(".", slash);
                    String ofname = s.substring(slash + 1, dot);
                    M24HelpFrame f = M24HelpFrame.findFrame(ofname);
                    f.setState(0);
                    f.toFront();
                    ((Window)f).setVisible(true);
                }
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (this.fname.equals("notes")) {
            prefs.setBoolean("help_notesVisible", false);
            if (!b) {
                prefs.setLastFrameClosed("notes");
            }
        } else if (this.fname.equals("faq")) {
            prefs.setBoolean("help_faqVisible", false);
            if (!b) {
                prefs.setLastFrameClosed("faq");
            }
        } else {
            prefs.setBoolean("help_guideVisible", false);
            if (!b) {
                prefs.setLastFrameClosed("guide");
            }
        }
    }

    private static void findBrowserCommands() {
        browserExecs = null;
        if (M24Globals.isAppletContext()) {
            return;
        }
        if (System.getProperty("os.name").startsWith("Windows")) {
            browserExecs = new String[]{WINDOWS_DLL};
        } else if (M24Globals.isMacintosh()) {
            Vector<String> browsers = new Vector<String>();
            try {
                Process p = Runtime.getRuntime().exec("which open");
                if (p.waitFor() == 0) {
                    browsers.add("/usr/bin/open {0}");
                }
            }
            catch (IOException exc) {
            }
            catch (InterruptedException exc) {
                // empty catch block
            }
            browserExecs = browsers.size() == 0 ? null : browsers.toArray(new String[0]);
        } else {
            Process p;
            Vector<String> browsers = new Vector<String>();
            try {
                p = Runtime.getRuntime().exec("which firebird");
                if (p.waitFor() == 0) {
                    browsers.add("firebird -remote openURL({0})");
                    browsers.add("firebird {0}");
                }
            }
            catch (Exception exc) {
                // empty catch block
            }
            try {
                p = Runtime.getRuntime().exec("which mozilla");
                if (p.waitFor() == 0) {
                    browsers.add("mozilla -remote openURL({0})");
                    browsers.add("mozilla {0}");
                }
            }
            catch (Exception exc) {
                // empty catch block
            }
            try {
                p = Runtime.getRuntime().exec("which opera");
                if (p.waitFor() == 0) {
                    browsers.add("opera -remote openURL({0})");
                    browsers.add("opera {0}");
                }
            }
            catch (Exception exc) {
                // empty catch block
            }
            try {
                p = Runtime.getRuntime().exec("which galeon");
                if (p.waitFor() == 0) {
                    browsers.add("galeon {0}");
                }
            }
            catch (Exception exc) {
                // empty catch block
            }
            try {
                p = Runtime.getRuntime().exec("which konqueror");
                if (p.waitFor() == 0) {
                    browsers.add("konqueror {0}");
                }
            }
            catch (Exception exc) {
                // empty catch block
            }
            try {
                p = Runtime.getRuntime().exec("which netscape");
                if (p.waitFor() == 0) {
                    browsers.add("netscape -remote openURL({0})");
                    browsers.add("netscape {0}");
                }
            }
            catch (Exception exc) {
                // empty catch block
            }
            try {
                p = Runtime.getRuntime().exec("which xterm");
                if (p.waitFor() == 0 && (p = Runtime.getRuntime().exec("which lynx")).waitFor() == 0) {
                    browsers.add("xterm -e lynx {0}");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            browserExecs = browsers.size() == 0 ? null : browsers.toArray(new String[0]);
        }
    }

    public static void displayURL(URL url) throws IOException {
        if (browserExecs == null || browserExecs.length == 0) {
            if (M24Globals.isMacintosh()) {
                boolean success = false;
                try {
                    Class<?> nSWorkspace;
                    if (new File("/System/Library/Java/com/apple/cocoa/application/NSWorkspace.class").exists()) {
                        URLClassLoader classLoader = new URLClassLoader(new URL[]{new File("/System/Library/Java").toURL()});
                        nSWorkspace = Class.forName("com.apple.cocoa.application.NSWorkspace", true, classLoader);
                    } else {
                        nSWorkspace = Class.forName("com.apple.cocoa.application.NSWorkspace");
                    }
                    Method sharedWorkspace = nSWorkspace.getMethod("sharedWorkspace", new Class[0]);
                    Object workspace = sharedWorkspace.invoke(null, new Object[0]);
                    Method openURL = nSWorkspace.getMethod("openURL", Class.forName("java.net.URL"));
                    success = (Boolean)openURL.invoke(workspace, url);
                }
                catch (Exception exc) {
                    // empty catch block
                }
                if (!success) {
                    try {
                        Class<?> mrjFileUtils = Class.forName("com.apple.mrj.MRJFileUtils");
                        Method openURL = mrjFileUtils.getMethod("openURL", Class.forName("java.lang.String"));
                        openURL.invoke(null, url);
                    }
                    catch (Exception exc) {
                        System.err.println(exc.getMessage());
                        throw new IOException("Browser launch failed.");
                    }
                }
            } else {
                throw new IOException("Browser exec command not defined.");
            }
            return;
        }
        String command = null;
        boolean found = false;
        try {
            for (int i = 0; i < browserExecs.length && !found; ++i) {
                try {
                    command = MessageFormat.format(browserExecs[i], url.toString());
                    StringTokenizer t = new StringTokenizer(command, " ");
                    int tcount = t.countTokens();
                    String[] args = new String[tcount];
                    for (int j = 0; j < tcount; ++j) {
                        args[j] = t.nextToken();
                    }
                    if (command.equals(WINDOWS_DLL) && (args[2].toLowerCase().endsWith("html") || args[2].toLowerCase().endsWith("htm"))) {
                        File sc = File.createTempFile("OpenInBrowser", ".url");
                        sc = sc.getCanonicalFile();
                        sc.deleteOnExit();
                        PrintWriter pw = new PrintWriter(new FileWriter(sc));
                        pw.println("[InternetShortcut]");
                        pw.println("URL=" + args[2]);
                        pw.close();
                        args[2] = sc.getCanonicalPath();
                    }
                    Process p = Runtime.getRuntime().exec(args);
                    for (int j = 0; j < 2; ++j) {
                        try {
                            Thread.currentThread();
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (Exception exc) {
                            // empty catch block
                        }
                    }
                    if (p.exitValue() != 0) continue;
                    found = true;
                    continue;
                }
                catch (Exception exc) {
                    System.err.println("Warning: " + exc.getMessage());
                }
            }
            if (!found) {
                throw new IOException("Browser launch failed");
            }
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
    }

    static {
        M24HelpFrame.findBrowserCommands();
    }
}

