/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24;

import gov.nasa.giss.mapping.landmarks.LandmarkList;
import gov.nasa.giss.mars24.M24Preferences;
import gov.nasa.giss.mars24.M24Timekeeper;
import java.applet.AppletContext;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.text.DecimalFormat;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

final class M24Globals {
    private static final int APPLET_CONTEXT = 1;
    private static final int APPLICATION_CONTEXT = 3;
    private static final int PLUGIN_CONTEXT = 5;
    public static final EmptyBorder STANDARD_BORDER = new EmptyBorder(6, 6, 6, 6);
    public static final int GAP = 6;
    public static final DecimalFormat FORMAT_X0 = new DecimalFormat("0");
    public static final DecimalFormat FORMAT_20 = new DecimalFormat("00");
    public static final DecimalFormat FORMAT_X1 = new DecimalFormat("0.0");
    public static final DecimalFormat FORMAT_X2 = new DecimalFormat("0.00");
    public static final DecimalFormat FORMAT_X3 = new DecimalFormat("0.000");
    private static int context = 1;
    private static AppletContext appletContext = null;
    private static boolean isMacOS = false;
    private static JFrame debugFrame;
    private static JTextArea debugTA;
    private static M24Preferences prefs;
    private static M24Timekeeper timekeeper;
    private static LandmarkList landmarks;

    M24Globals() {
    }

    public static M24Preferences getSettings() {
        return prefs;
    }

    public static void setSettings(M24Preferences s) {
        prefs = s;
    }

    public static M24Timekeeper getTimekeeper() {
        return timekeeper;
    }

    public static void setTimekeeper(M24Timekeeper tk) {
        timekeeper = tk;
    }

    public static LandmarkList getLandmarks() {
        return landmarks;
    }

    public static void setLandmarks(LandmarkList ll) {
        landmarks = ll;
    }

    public static boolean isApplicationContext() {
        return context == 3;
    }

    public static void setApplicationContext() {
        context = 3;
    }

    public static boolean isAppletContext() {
        return context == 1;
    }

    public static AppletContext getAppletContext() {
        return appletContext;
    }

    public static void setAppletContext(AppletContext ac) {
        appletContext = ac;
        context = 1;
    }

    public static boolean isPluginContext() {
        return context == 5;
    }

    public static void setPluginContext() {
        context = 5;
    }

    public static boolean isMacintosh() {
        return isMacOS;
    }

    public static Rectangle getMainScreenBounds() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        if (gs == null || gs.length < 1) {
            return null;
        }
        GraphicsDevice gd = gs[0];
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        if (gc == null) {
            return null;
        }
        return gc.getBounds();
    }

    public static void debugAppend(String message) {
        if (debugTA == null) {
            debugTA = new JTextArea("Debug messages...\n");
            debugTA.setSize(600, 600);
            debugTA.setMinimumSize(new Dimension(600, 600));
            debugTA.setPreferredSize(new Dimension(600, 600));
            debugFrame = new JFrame();
            debugFrame.setTitle("Mars24 Debug");
            debugFrame.setName("Mars24 Debug");
            debugFrame.getContentPane().add(debugTA);
            debugFrame.pack();
        }
        debugFrame.setVisible(true);
        debugFrame.toFront();
        debugTA.append(message);
        debugTA.append("\n");
    }

    public static CompoundBorder createPaddedTitleBorder(String s) {
        return new CompoundBorder(new TitledBorder(s), new EmptyBorder(2, 8, 8, 8));
    }

    public static Image loadImage(InputStream is) {
        BufferedInputStream bis = new BufferedInputStream(is);
        byte[] bigbuffer = new byte[]{};
        try {
            while (bis.available() > 0) {
                int i;
                byte[] buffer = new byte[bis.available()];
                bis.read(buffer);
                byte[] newbuffer = new byte[bigbuffer.length + buffer.length];
                for (i = 0; i < bigbuffer.length; ++i) {
                    newbuffer[i] = bigbuffer[i];
                }
                for (i = 0; i < buffer.length; ++i) {
                    newbuffer[bigbuffer.length + i] = buffer[i];
                }
                bigbuffer = newbuffer;
            }
            is.close();
        }
        catch (Exception exc) {
            // empty catch block
        }
        Image img = new ImageIcon(Toolkit.getDefaultToolkit().createImage(bigbuffer)).getImage();
        return img;
    }

    public static void reduceContainerFonts(Container container, int reduction) {
        Component[] children = container.getComponents();
        for (int i = 0; i < children.length; ++i) {
            Component c = children[i];
            if (c == null) continue;
            Font f = c.getFont();
            if (f != null) {
                c.setFont(f.deriveFont((float)(f.getSize() - reduction)));
            }
            if (!(c instanceof Container) || c instanceof JComboBox) continue;
            M24Globals.reduceContainerFonts((Container)c, reduction);
        }
    }

    static {
        prefs = null;
        try {
            if (System.getProperty("mrj.version") != null) {
                isMacOS = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

