/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24;

import com.apple.mrj.MRJAboutHandler;
import com.apple.mrj.MRJApplicationUtils;
import com.apple.mrj.MRJOpenDocumentHandler;
import com.apple.mrj.MRJQuitHandler;
import gov.nasa.giss.mars24.M24AboutFrame;
import gov.nasa.giss.mars24.M24Globals;
import gov.nasa.giss.mars24.M24Menubar;
import gov.nasa.giss.mars24.M24WindowMenu;
import gov.nasa.giss.mars24.Mars24;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.Method;
import javax.swing.JFrame;

public class M24ForMac
extends JFrame
implements MRJAboutHandler,
MRJOpenDocumentHandler,
MRJQuitHandler {
    private static M24ForMac macHandler;
    private static float javaVersion;
    private static float mrjVersion;

    public static void register() {
        if (macHandler == null) {
            macHandler = new M24ForMac();
        }
        macHandler.setVisible(true);
    }

    private M24ForMac() {
        String prop = System.getProperty("java.version");
        javaVersion = new Float(prop.substring(0, 3)).floatValue();
        prop = System.getProperty("mrj.version");
        if (prop != null) {
            int len = prop.length();
            int pos = prop.indexOf(46);
            if (pos != -1 && pos != len - 1) {
                pos = prop.indexOf(46, pos + 1);
            }
            if (pos == -1) {
                pos = len;
            }
            mrjVersion = new Float(prop.substring(0, pos)).floatValue();
        }
        this.setSystemProperties();
        MRJApplicationUtils.registerAboutHandler((MRJAboutHandler)this);
        MRJApplicationUtils.registerOpenDocumentHandler((MRJOpenDocumentHandler)this);
        MRJApplicationUtils.registerQuitHandler((MRJQuitHandler)this);
        this.setJMenuBar(new M24Menubar(this));
        this.setDefaultCloseOperation(0);
        this.setName("Mars24 for Mac");
        this.setTitle(null);
        this.setResizable(false);
        this.getContentPane().setLayout(null);
        if (mrjVersion >= 4.0f) {
            try {
                Method mthd = this.getClass().getMethod("setUndecorated", Boolean.TYPE);
                mthd.invoke((Object)this, Boolean.TRUE);
            }
            catch (Exception exception) {}
        } else {
            this.setLocation(-5000, -5000);
        }
        this.setSize(0, 0);
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                ((M24WindowMenu)((M24Menubar)M24ForMac.this.getJMenuBar()).getMenu("Window")).update();
            }
        });
    }

    private void setSystemProperties() {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Mars24");
        System.setProperty("apple.awt.showGrowBox", "true");
        System.setProperty("apple.awt.antialiasing", "true");
        System.setProperty("apple.awt.textantialiasing", "true");
        System.setProperty("apple.awt.rendering", "VALUE_RENDER_QUALITY");
        System.setProperty("apple.awt.fractionalmetrics", "VALUE_FRACTIONALMETRICS_ON");
        System.setProperty("apple.awt.graphics.Optiapple.awt.graphics.OptimizeShapes", "false");
        System.setProperty("apple.awt.window.position.forceSafeCreation", "false");
        System.setProperty("apple.awt.window.position.forceSafeProgrammaticPositioning", "false");
        System.setProperty("com.apple.macos.useScreenMenuBar", "true");
        System.setProperty("com.apple.mrj.application.growbox.intrudes", "true");
    }

    public void handleAbout() {
        M24AboutFrame.reveal();
    }

    public void handleOpenFile(File f) {
        if (!f.exists()) {
            return;
        }
        M24Globals.getSettings().read(this, f);
    }

    public void handleQuit() {
        Mars24.quit();
    }

    static {
        mrjVersion = -1.0f;
    }
}

