/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24;

import gov.nasa.giss.gui.JMenuItem2;
import gov.nasa.giss.mars24.M24AbstractMenu;
import gov.nasa.giss.mars24.M24ForMac;
import gov.nasa.giss.mars24.M24Globals;
import gov.nasa.giss.mars24.M24HelpFrame;
import gov.nasa.giss.mars24.M24Preferences;
import gov.nasa.giss.mars24.Mars24;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.AbstractAction;
import javax.swing.JMenu;

class M24FileMenu
extends M24AbstractMenu {
    private Frame frame;
    private static File saveFile = null;

    M24FileMenu(Frame f) {
        super("File");
        AbstractAction a;
        this.frame = f;
        this.add(this.makeSimpleMenuItem("new", "New", "meta N", null)).setEnabled(false);
        if (M24Globals.isApplicationContext()) {
            a = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    M24FileMenu.this.handleOpen();
                }
            };
            this.add(this.makeSimpleMenuItem("open", "Open\u2026", "meta O", a)).setEnabled(true);
        } else {
            this.add(this.makeSimpleMenuItem("open", "Open\u2026", "meta O", null)).setEnabled(false);
        }
        a = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                M24FileMenu.this.frame.setVisible(false);
            }
        };
        JMenuItem2 jmi = this.makeSimpleMenuItem("close", "Close", "meta W", a);
        if (M24Globals.isAppletContext()) {
            this.add(jmi).setEnabled(true);
        } else if (M24Globals.isMacintosh()) {
            this.add(jmi).setEnabled(!(this.frame instanceof M24ForMac));
        } else {
            this.add(jmi).setEnabled(true);
        }
        this.addSeparator();
        this.add(this.makeSimpleMenuItem("save-image", "Save Image", "meta S", null)).setEnabled(false);
        this.add(this.makeSimpleMenuItem("save-image-as", "Save Image As\u2026", "meta shift S", null)).setEnabled(false);
        if (M24Globals.isApplicationContext()) {
            a = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    M24FileMenu.this.handleSaveSettings();
                }
            };
            this.add(this.makeSimpleMenuItem("save-settings-as", "Save Settings As\u2026", null, a)).setEnabled(true);
        } else {
            this.add(this.makeSimpleMenuItem("save-settings-as", "Save Settings As\u2026", null, null)).setEnabled(false);
        }
        JMenu revertMenu = new JMenu("Revert Settings");
        AbstractAction a2 = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                M24Globals.getSettings().restoreDefaults();
                M24FileMenu.this.manageWindowVisibility();
            }
        };
        revertMenu.add(this.makeSimpleMenuItem("factory-defaults", "Factory Defaults", "meta shift F", a2)).setEnabled(true);
        a2 = null;
        if (M24Globals.isApplicationContext()) {
            a2 = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    M24Globals.getSettings().revert();
                    M24FileMenu.this.manageWindowVisibility();
                }
            };
        }
        revertMenu.add(this.makeSimpleMenuItem("latest-save", "Latest Save", "meta shift R", a2)).setEnabled(M24Globals.isApplicationContext());
        revertMenu.setEnabled(true);
        this.add(revertMenu);
        this.addSeparator();
        this.add(this.makeSimpleMenuItem("print", "Print\u2026", "meta P", null)).setEnabled(false);
        if (M24Globals.isApplicationContext() && !M24Globals.isMacintosh()) {
            this.addSeparator();
            a2 = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    Mars24.quit();
                }
            };
            this.add(this.makeSimpleMenuItem("quit", "Quit", "meta Q", a2)).setEnabled(true);
        }
    }

    private void handleOpen() {
        FileDialog fd = new FileDialog(this.frame, "Please select a Mars24 prefs file", 0);
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (name.toLowerCase().endsWith(".m24")) {
                    return true;
                }
                return new File(dir, name).isDirectory();
            }
        };
        fd.setFilenameFilter(filter);
        fd.setVisible(true);
        if (fd.getFile() == null) {
            return;
        }
        M24Globals.getSettings().read(this.frame, new File(fd.getDirectory(), fd.getFile()));
        this.manageWindowVisibility();
    }

    private void handleSaveSettings() {
        if (M24Globals.isAppletContext()) {
            return;
        }
        FileDialog fd = new FileDialog(this.frame, "Save current prefs as\u2026", 1);
        if (saveFile == null) {
            fd.setFile("untitled.m24");
        } else {
            fd.setFile(saveFile.getName());
        }
        fd.setVisible(true);
        if (fd.getFile() == null) {
            return;
        }
        String fname = fd.getFile().toLowerCase().endsWith(".m24") ? fd.getFile() : fd.getFile() + ".m24";
        try {
            saveFile = new File(fd.getDirectory(), fname);
            M24Globals.getSettings().saveSettings(saveFile);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    private void manageWindowVisibility() {
        M24Preferences prefs = M24Globals.getSettings();
        Frame[] flist = Frame.getFrames();
        for (int i = 0; i < flist.length; ++i) {
            String n = flist[i].getName();
            if (n == null) continue;
            if (n.equals("faq")) {
                flist[i].setVisible(prefs.getBoolean("help_faqVisible"));
                continue;
            }
            if (n.equals("notes")) {
                flist[i].setVisible(prefs.getBoolean("help_notesVisible"));
                continue;
            }
            if (n.equals("guide")) {
                flist[i].setVisible(prefs.getBoolean("help_guideVisible"));
                continue;
            }
            if (n.equals("time")) {
                flist[i].setVisible(prefs.getBoolean("timeFrame_visible"));
                continue;
            }
            if (n.equals("plot")) {
                flist[i].setVisible(prefs.getBoolean("plotFrame_visible"));
                continue;
            }
            if (!n.equals("controls")) continue;
            flist[i].setVisible(prefs.getBoolean("controlsFrame_visible"));
        }
        if (prefs.getBoolean("help_faqVisible")) {
            M24HelpFrame.findFrame("faq").setVisible(true);
        }
        if (prefs.getBoolean("help_notesVisible")) {
            M24HelpFrame.findFrame("notes").setVisible(true);
        }
        if (prefs.getBoolean("help_guideVisible")) {
            M24HelpFrame.findFrame("guide").setVisible(true);
        }
    }
}

