/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24;

import gov.nasa.giss.gui.JMenuItem2;
import gov.nasa.giss.mars24.M24AbstractMenu;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultEditorKit;

class M24EditMenu
extends M24AbstractMenu {
    private JFrame frame;

    M24EditMenu(JFrame f) {
        super("Edit");
        this.frame = f;
        this.add(this.makeFocusedComponentMenuItem("undo", "Undo", "meta Z", "undo-action")).setEnabled(false);
        this.addSeparator();
        this.add(this.makeFocusedComponentMenuItem("cut", "Cut", "meta X", "cut-to-clipboard")).setEnabled(true);
        this.add(this.makeFocusedComponentMenuItem("copy", "Copy", "meta C", "copy-to-clipboard")).setEnabled(true);
        this.add(this.makeFocusedComponentMenuItem("paste", "Paste", "meta V", "paste-from-clipboard")).setEnabled(true);
        this.add(this.makeSimpleMenuItem("clear", "Clear", null, null)).setEnabled(false);
        this.add(this.makeFocusedComponentMenuItem("select-all", "Select All", "meta A", "select-all")).setEnabled(true);
    }

    protected JMenuItem2 makeFocusedComponentMenuItem(String pname, String text, String ksdesc, String aname) {
        KeyStroke ks = null;
        if (ksdesc != null) {
            ks = KeyStroke.getKeyStroke(ksdesc);
        }
        AbstractAction action = aname == null ? null : (aname.equals("cut-to-clipboard") ? new DefaultEditorKit.CutAction() : (aname.equals("copy-to-clipboard") ? new DefaultEditorKit.CopyAction() : (aname.equals("paste-from-clipboard") ? new DefaultEditorKit.PasteAction() : new AbstractAction(text){

            public void actionPerformed(ActionEvent e) {
                try {
                    JFrame f = (JFrame)M24EditMenu.this.getTopLevelAncestor();
                    if (f == null) {
                        return;
                    }
                    JComponent jc = (JComponent)f.getFocusOwner();
                    if (jc == null) {
                        return;
                    }
                    String name = e.getActionCommand();
                    Action a = jc.getActionMap().get(name);
                    if (a != null) {
                        a.actionPerformed(new ActionEvent(jc, 1001, null));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        })));
        JMenuItem2 mi = new JMenuItem2(action);
        mi.setName(pname);
        mi.setText(text);
        if (ks != null) {
            mi.setAccelerator(ks);
        }
        return mi;
    }
}

