/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24;

import gov.nasa.giss.gui.QuickBox;
import gov.nasa.giss.mars24.M24Globals;
import gov.nasa.giss.mars24.M24PlotPanel;
import gov.nasa.giss.mars24.M24Preferences;
import gov.nasa.giss.mars24.M24TimePanel;
import gov.nasa.giss.mars24.M24Timekeeper;
import gov.nasa.giss.text.DoubleDocument;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.schmunk.gui.FGConstraint;
import net.schmunk.gui.FlexingGridLayout;

public class M24EarthTimeControls
extends JPanel {
    private static final String LIGHT_MINUTES = "Light Minutes";
    private static final String LIGHT_SECONDS = "Light Seconds";
    private static final String ASTRONOMICAL_UNITS = "Astronomical Units";
    private static final String KILOMETERS = "Kilometers";
    private static final String[] DISTANCE_CHOICES = new String[]{"Light Minutes", "Light Seconds", "Astronomical Units", "Kilometers"};
    private static final String[] JULIAN_CHOICES = new String[]{"JD", "MJD"};
    private M24Preferences prefs = M24Globals.getSettings();
    private M24Timekeeper timekeeper = M24Globals.getTimekeeper();
    private M24PlotPanel plotDisplay;
    private M24TimePanel timeDisplay;
    private JRadioButton useCurrentTimeButton;
    private JRadioButton useOffsetTimeButton;
    private JRadioButton useFixedTimeButton;
    private JRadioButton useFixedJdButton;
    private JTextField fixedDateTF;
    private JTextField fixedTimeTF;
    private JTextField jdValTF;
    private JTextField yOffsetTF;
    private JTextField dOffsetTF;
    private JTextField hOffsetTF;
    private JTextField mOffsetTF;
    private JTextField sOffsetTF;
    private JCheckBox doyCB;
    private JComboBox distanceUnitsMenu;

    public M24EarthTimeControls(M24PlotPanel p1, M24TimePanel p2) {
        if (p1 == null) {
            throw new IllegalArgumentException("Plot panel cannot be null");
        }
        this.plotDisplay = p1;
        if (p2 == null) {
            throw new IllegalArgumentException("Time panel cannot be null");
        }
        this.timeDisplay = p2;
        this.useCurrentTimeButton = new JRadioButton("");
        this.useOffsetTimeButton = new JRadioButton("");
        this.useFixedTimeButton = new JRadioButton("");
        this.useFixedJdButton = new JRadioButton("");
        ButtonGroup methodGroup = new ButtonGroup();
        methodGroup.add(this.useCurrentTimeButton);
        methodGroup.add(this.useFixedTimeButton);
        methodGroup.add(this.useOffsetTimeButton);
        methodGroup.add(this.useFixedJdButton);
        this.yOffsetTF = new JTextField("00.0", 3);
        this.dOffsetTF = new JTextField("00.0", 3);
        this.hOffsetTF = new JTextField("00.0", 3);
        this.mOffsetTF = new JTextField("00.0", 3);
        this.sOffsetTF = new JTextField("00.0", 3);
        this.yOffsetTF.setDocument(new DoubleDocument());
        this.dOffsetTF.setDocument(new DoubleDocument());
        this.hOffsetTF.setDocument(new DoubleDocument());
        this.mOffsetTF.setDocument(new DoubleDocument());
        this.sOffsetTF.setDocument(new DoubleDocument());
        QuickBox offsetTimeBox = QuickBox.createHorizontalBox(2, new Component[]{this.yOffsetTF, new JLabel("y + "), this.dOffsetTF, new JLabel("d + "), this.hOffsetTF, new JLabel("h + "), this.mOffsetTF, new JLabel("m + "), this.sOffsetTF, new JLabel("s")});
        this.jdValTF = new JTextField("2451544.5");
        this.fixedDateTF = new JTextField("July 20, 1976");
        this.fixedTimeTF = new JTextField("11:53:06");
        Dimension tfsize = this.fixedTimeTF.getPreferredSize();
        if (tfsize.width < this.fixedDateTF.getPreferredSize().width + 5) {
            tfsize.width = this.fixedDateTF.getPreferredSize().width + 5;
        }
        this.fixedTimeTF.setMinimumSize(tfsize);
        this.fixedTimeTF.setPreferredSize(tfsize);
        this.fixedDateTF.setMinimumSize(tfsize);
        this.fixedDateTF.setPreferredSize(tfsize);
        tfsize = this.jdValTF.getPreferredSize();
        tfsize.width += 5;
        this.jdValTF.setMinimumSize(tfsize);
        this.jdValTF.setMaximumSize(tfsize);
        this.jdValTF.setPreferredSize(tfsize);
        QuickBox fixedTimeBox = QuickBox.createHorizontalBox(2, new Component[]{new JLabel("Set UTC = "), this.fixedTimeTF, new JLabel(" on "), this.fixedDateTF});
        QuickBox julianDateBox = QuickBox.createHorizontalBox(2, new Component[]{new JLabel("Fixed Julian Date: Set MJD = "), this.jdValTF});
        this.doyCB = new JCheckBox("Format date as YYYY-DDD", false);
        this.distanceUnitsMenu = new JComboBox<String>(DISTANCE_CHOICES);
        QuickBox distanceUnitsBox = QuickBox.createHorizontalBox(2, new Component[]{new JLabel("Show distance units in "), this.distanceUnitsMenu});
        FlexingGridLayout fgl = new FlexingGridLayout(new Dimension(2, 10), 2, 4);
        fgl.setColumnWeight(0, 0.0f);
        fgl.setColumnWeight(1, 1.0f);
        this.setLayout(fgl);
        this.setBorder(M24Globals.STANDARD_BORDER);
        this.add((Component)new JLabel("For all calculations, set Earth time to:"), new FGConstraint(new Rectangle(0, 0, 2, 1), 0.0, 0.5));
        this.add((Component)this.useCurrentTimeButton, new FGConstraint(new Rectangle(0, 1, 1, 1), 0.5, 0.5));
        this.add((Component)new JLabel("Current date and time"), new FGConstraint(new Rectangle(1, 1, 1, 1), 0.0, 0.5));
        this.add((Component)this.useOffsetTimeButton, new FGConstraint(new Rectangle(0, 2, 1, 1), 0.5, 0.5));
        this.add((Component)new JLabel("Offset: To current date and time, add:"), new FGConstraint(new Rectangle(1, 2, 1, 1), 0.0, 0.5));
        this.add((Component)offsetTimeBox, new FGConstraint(new Rectangle(1, 3, 1, 1), 0.0, 0.5));
        this.add((Component)this.useFixedTimeButton, new FGConstraint(new Rectangle(0, 4, 1, 1), 0.5, 0.5));
        this.add((Component)new JLabel("Fixed date and time:"), new FGConstraint(new Rectangle(1, 4, 1, 1), 0.0, 0.5));
        this.add((Component)fixedTimeBox, new FGConstraint(new Rectangle(1, 5, 1, 1), 0.0, 0.5));
        this.add((Component)this.useFixedJdButton, new FGConstraint(new Rectangle(0, 6, 1, 1), 0.5, 0.5));
        this.add((Component)julianDateBox, new FGConstraint(new Rectangle(1, 6, 1, 1), 0.0, 0.5));
        this.add((Component)this.doyCB, new FGConstraint(new Rectangle(0, 8, 2, 1), 0.0, 0.5));
        this.add((Component)distanceUnitsBox, new FGConstraint(new Rectangle(0, 9, 2, 1), 0.0, 0.5));
        this.addListeners();
    }

    private void addListeners() {
        ActionListener timeMethodAL = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (M24EarthTimeControls.this.useFixedTimeButton.isSelected()) {
                    M24EarthTimeControls.this.prefs.set("earthTime_method", "fixed");
                } else if (M24EarthTimeControls.this.useOffsetTimeButton.isSelected()) {
                    M24EarthTimeControls.this.prefs.set("earthTime_method", "offset");
                } else if (M24EarthTimeControls.this.useFixedJdButton.isSelected()) {
                    M24EarthTimeControls.this.prefs.set("earthTime_method", "jd");
                } else {
                    M24EarthTimeControls.this.prefs.set("earthTime_method", "current");
                }
            }
        };
        this.useCurrentTimeButton.addActionListener(timeMethodAL);
        this.useFixedTimeButton.addActionListener(timeMethodAL);
        this.useOffsetTimeButton.addActionListener(timeMethodAL);
        this.useFixedJdButton.addActionListener(timeMethodAL);
        ActionListener fixedTimeAL = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JTextField tf = (JTextField)e.getSource();
                if (tf == M24EarthTimeControls.this.fixedDateTF) {
                    M24EarthTimeControls.this.prefs.set("earthTime_fixedDate", tf.getText());
                } else if (tf == M24EarthTimeControls.this.fixedTimeTF) {
                    M24EarthTimeControls.this.prefs.set("earthTime_fixedTime", tf.getText());
                } else if (tf == M24EarthTimeControls.this.jdValTF) {
                    M24EarthTimeControls.this.prefs.setDouble("earthTime_jdval", tf.getText());
                }
            }
        };
        FocusListener fixedTimeFL = new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                JTextField tf = (JTextField)e.getSource();
                if (tf == M24EarthTimeControls.this.fixedDateTF) {
                    M24EarthTimeControls.this.prefs.set("earthTime_fixedDate", tf.getText());
                } else if (tf == M24EarthTimeControls.this.fixedTimeTF) {
                    M24EarthTimeControls.this.prefs.set("earthTime_fixedTime", tf.getText());
                } else if (tf == M24EarthTimeControls.this.jdValTF) {
                    M24EarthTimeControls.this.prefs.setDouble("earthTime_jdval", tf.getText());
                }
            }
        };
        this.fixedDateTF.addActionListener(fixedTimeAL);
        this.fixedDateTF.addFocusListener(fixedTimeFL);
        this.fixedTimeTF.addActionListener(fixedTimeAL);
        this.fixedTimeTF.addFocusListener(fixedTimeFL);
        this.jdValTF.addActionListener(fixedTimeAL);
        this.jdValTF.addFocusListener(fixedTimeFL);
        ActionListener offsetTimeAL = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                double dx = 0.0;
                try {
                    String val = ((JTextField)e.getSource()).getText();
                    dx = val.equals("-") || val.equals(".") ? 0.0 : Double.parseDouble(val);
                }
                catch (Exception exc) {
                    M24EarthTimeControls.this.getToolkit().beep();
                    ((JTextField)e.getSource()).requestFocus();
                    return;
                }
                if (e.getSource() == M24EarthTimeControls.this.yOffsetTF) {
                    M24EarthTimeControls.this.prefs.setDouble("earthTime_offsetYear", dx);
                } else if (e.getSource() == M24EarthTimeControls.this.dOffsetTF) {
                    M24EarthTimeControls.this.prefs.setDouble("earthTime_offsetDay", dx);
                } else if (e.getSource() == M24EarthTimeControls.this.hOffsetTF) {
                    M24EarthTimeControls.this.prefs.setDouble("earthTime_offsetHour", dx);
                } else if (e.getSource() == M24EarthTimeControls.this.mOffsetTF) {
                    M24EarthTimeControls.this.prefs.setDouble("earthTime_offsetMin", dx);
                } else if (e.getSource() == M24EarthTimeControls.this.sOffsetTF) {
                    M24EarthTimeControls.this.prefs.setDouble("earthTime_offsetSec", dx);
                }
            }
        };
        FocusListener offsetTimeFL = new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                double dx = 0.0;
                try {
                    String val = ((JTextField)e.getSource()).getText();
                    dx = val.equals("-") || val.equals(".") ? 0.0 : Double.parseDouble(val);
                }
                catch (Exception exc) {
                    M24EarthTimeControls.this.getToolkit().beep();
                    ((JTextField)e.getSource()).requestFocus();
                    return;
                }
                if (e.getSource() == M24EarthTimeControls.this.yOffsetTF) {
                    M24EarthTimeControls.this.prefs.setDouble("earthTime_offsetYear", dx);
                } else if (e.getSource() == M24EarthTimeControls.this.dOffsetTF) {
                    M24EarthTimeControls.this.prefs.setDouble("earthTime_offsetDay", dx);
                } else if (e.getSource() == M24EarthTimeControls.this.hOffsetTF) {
                    M24EarthTimeControls.this.prefs.setDouble("earthTime_offsetHour", dx);
                } else if (e.getSource() == M24EarthTimeControls.this.mOffsetTF) {
                    M24EarthTimeControls.this.prefs.setDouble("earthTime_offsetMin", dx);
                } else if (e.getSource() == M24EarthTimeControls.this.sOffsetTF) {
                    M24EarthTimeControls.this.prefs.setDouble("earthTime_offsetSec", dx);
                }
            }
        };
        this.yOffsetTF.addActionListener(offsetTimeAL);
        this.dOffsetTF.addActionListener(offsetTimeAL);
        this.hOffsetTF.addActionListener(offsetTimeAL);
        this.mOffsetTF.addActionListener(offsetTimeAL);
        this.sOffsetTF.addActionListener(offsetTimeAL);
        this.yOffsetTF.addFocusListener(offsetTimeFL);
        this.dOffsetTF.addFocusListener(offsetTimeFL);
        this.mOffsetTF.addFocusListener(offsetTimeFL);
        this.hOffsetTF.addFocusListener(offsetTimeFL);
        this.sOffsetTF.addFocusListener(offsetTimeFL);
        this.doyCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Boolean value = new Boolean(M24EarthTimeControls.this.doyCB.isSelected());
                M24EarthTimeControls.this.prefs.set("earthTime_dateAsDOY", value);
            }
        });
        this.distanceUnitsMenu.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                String value = M24EarthTimeControls.this.distanceUnitsMenu.getSelectedItem().toString();
                M24EarthTimeControls.this.prefs.set("earthTime_distanceUnits", value);
            }
        });
    }

    public void setAll() {
        String eMethod = this.prefs.getString("earthTime_method").toLowerCase();
        if (eMethod == null) {
            eMethod = "current";
        }
        this.useCurrentTimeButton.setSelected(eMethod.indexOf("current") > -1);
        this.useOffsetTimeButton.setSelected(eMethod.indexOf("offset") > -1);
        this.useFixedTimeButton.setSelected(eMethod.indexOf("fixed") > -1);
        this.useFixedJdButton.setSelected(eMethod.equals("jd"));
        try {
            this.yOffsetTF.setText(this.prefs.getString("earthTime_offsetYear"));
        }
        catch (Exception exc) {
            this.yOffsetTF.setText("0");
        }
        try {
            this.dOffsetTF.setText(this.prefs.getString("earthTime_offsetDay"));
        }
        catch (Exception exc) {
            this.dOffsetTF.setText("0");
        }
        try {
            this.hOffsetTF.setText(this.prefs.getString("earthTime_offsetHour"));
        }
        catch (Exception exc) {
            this.hOffsetTF.setText("0");
        }
        try {
            this.mOffsetTF.setText(this.prefs.getString("earthTime_offsetMin"));
        }
        catch (Exception exc) {
            this.mOffsetTF.setText("0");
        }
        try {
            this.sOffsetTF.setText(this.prefs.getString("earthTime_offsetSec"));
        }
        catch (Exception exc) {
            this.sOffsetTF.setText("0");
        }
        try {
            this.fixedDateTF.setText(this.prefs.getString("earthTime_fixedDate"));
        }
        catch (Exception exc) {
            this.fixedDateTF.setText("July 20, 1976");
        }
        try {
            this.fixedTimeTF.setText(this.prefs.getString("earthTime_fixedTime"));
        }
        catch (Exception exc) {
            this.fixedTimeTF.setText("11:53:06");
        }
        try {
            this.jdValTF.setText(this.prefs.getString("earthTime_jdval"));
        }
        catch (Exception exc) {
            this.jdValTF.setText("51544.0");
        }
        try {
            this.doyCB.setSelected(this.prefs.getBoolean("earthTime_dateAsDOY"));
        }
        catch (Exception exc) {
            this.doyCB.setSelected(false);
        }
        String dUnits = this.prefs.getString("earthTime_distanceUnits").toLowerCase();
        if (dUnits.equals("kilometers") || dUnits.equals("km")) {
            this.distanceUnitsMenu.setSelectedItem(KILOMETERS);
        } else if (dUnits.indexOf("astronomical") > -1 || dUnits.equals("au")) {
            this.distanceUnitsMenu.setSelectedItem(ASTRONOMICAL_UNITS);
        } else if (dUnits.indexOf("light sec") > -1) {
            this.distanceUnitsMenu.setSelectedItem(LIGHT_SECONDS);
        } else {
            this.distanceUnitsMenu.setSelectedItem(LIGHT_MINUTES);
        }
    }
}

