/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24;

import gov.nasa.giss.actions.PrintAction;
import gov.nasa.giss.mars24.M24DisplayPanel;
import gov.nasa.giss.mars24.M24Globals;
import gov.nasa.giss.mars24.M24Menubar;
import gov.nasa.giss.mars24.M24PlotPanel;
import gov.nasa.giss.mars24.M24Preferences;
import gov.nasa.giss.mars24.M24TimePanel;
import gov.nasa.giss.mars24.M24WindowMenu;
import gov.nasa.giss.mars24.SaveImageAction;
import gov.nasa.giss.mars24.SaveImageAsAction;
import gov.nasa.giss.prefs.PreferencesEvent;
import gov.nasa.giss.prefs.PreferencesListener;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingConstants;

public class M24DisplayFrame
extends JFrame
implements Printable,
SwingConstants,
PreferencesListener {
    private static M24Preferences prefs;
    private JComponent content;
    private File dstFile;
    private SaveImageAction saveImageAction;
    private SaveImageAsAction saveImageAsAction;
    private PrintAction printAction;
    private Point where = null;
    private int dwidth;
    private int dheight;

    public M24DisplayFrame(JComponent jc) {
        this.content = jc;
        if (prefs == null) {
            prefs = M24Globals.getSettings();
        }
        this.getContentPane().add(this.content);
        this.setDefaultCloseOperation(1);
        int hAlign = 0;
        int vAlign = 0;
        if (this.content instanceof M24TimePanel) {
            this.setName("time");
            this.setTitle("Mars24 - Time");
            hAlign = 2;
            vAlign = 3;
        } else if (this.content instanceof M24PlotPanel) {
            this.setName("plot");
            hAlign = 0;
            vAlign = 1;
        }
        this.updateSetting("all");
        this.setJMenuBar(new M24Menubar(this));
        if (M24Globals.isApplicationContext()) {
            this.saveImageAsAction = new SaveImageAsAction(this);
            this.saveImageAction = new SaveImageAction(this, this.saveImageAsAction);
            this.printAction = new PrintAction(this);
            M24Menubar mbar = (M24Menubar)this.getJMenuBar();
            mbar.getMenu("File").setItemAction("save-image", this.saveImageAction);
            mbar.getMenu("File").setItemAction("save-image-as", this.saveImageAsAction);
            mbar.getMenu("File").setItemAction("print", this.printAction);
            this.saveImageAction.setEnabled(true);
            this.saveImageAsAction.setEnabled(true);
            this.printAction.setEnabled(true);
        }
        this.pack();
        if (this.where == null) {
            Rectangle rr = M24Globals.getMainScreenBounds();
            if (rr == null) {
                this.where = new Point(25, 25);
            } else {
                int x = 25;
                int y = 25;
                Dimension psize = this.content.getPreferredSize();
                if (hAlign == 0) {
                    x = (rr.width - psize.width) / 2;
                } else if (hAlign == 4) {
                    x = rr.width - psize.width - 25;
                }
                if (vAlign == 0) {
                    y = (rr.height - psize.height) / 2;
                } else if (vAlign == 3) {
                    y = rr.height - psize.height - 25;
                }
                this.where = new Point(rr.x + x, rr.y + y);
            }
        }
        this.setLocation(this.where);
        this.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent e) {
                if (!M24DisplayFrame.this.isVisible()) {
                    return;
                }
                Point p = M24DisplayFrame.this.getLocationOnScreen();
                if (M24DisplayFrame.this.content instanceof M24TimePanel) {
                    prefs.setInt("timeFrame_leftEdge", p.x);
                    prefs.setInt("timeFrame_topEdge", p.y);
                } else {
                    prefs.setInt("plotFrame_leftEdge", p.x);
                    prefs.setInt("plotFrame_topEdge", p.y);
                }
            }

            public void componentResized(ComponentEvent e) {
                M24DisplayFrame.this.content.setSize(M24DisplayFrame.this.getContentPane().getSize());
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                ((M24WindowMenu)((M24Menubar)M24DisplayFrame.this.getJMenuBar()).getMenu("Window")).update();
                if (M24Globals.isAppletContext()) {
                    return;
                }
                if (M24DisplayFrame.this.content instanceof M24TimePanel) {
                    prefs.setBoolean("timeFrame_visible", true);
                } else if (M24DisplayFrame.this.content instanceof M24PlotPanel) {
                    prefs.setBoolean("plotFrame_visible", true);
                }
            }

            public void windowClosed(WindowEvent e) {
                if (M24DisplayFrame.this.content instanceof M24TimePanel) {
                    prefs.setBoolean("timeFrame_visible", false);
                } else if (M24DisplayFrame.this.content instanceof M24PlotPanel) {
                    prefs.setBoolean("plotFrame_visible", false);
                }
            }

            public void windowClosing(WindowEvent e) {
                if (M24DisplayFrame.this.content instanceof M24TimePanel) {
                    prefs.setBoolean("timeFrame_visible", false);
                    prefs.setLastFrameClosed("time");
                } else if (M24DisplayFrame.this.content instanceof M24PlotPanel) {
                    prefs.setBoolean("plotFrame_visible", false);
                    prefs.setLastFrameClosed("plot");
                }
            }
        });
        this.dwidth = this.getSize().width - this.content.getSize().width;
        this.dheight = this.getSize().height - this.content.getSize().height;
        this.setMaximizedBounds(new Rectangle(0, 0, this.content.getMaximumSize().width + this.dwidth, this.content.getMaximumSize().height + this.dheight));
        prefs.addSettingsListener(this);
    }

    public void setVisible(boolean b) {
        if (this.content instanceof M24TimePanel) {
            prefs.set("timeFrame_visible", new Boolean(b));
            if (!b) {
                prefs.setLastFrameClosed("time");
            }
        } else if (this.content instanceof M24PlotPanel) {
            prefs.set("plotFrame_visible", new Boolean(b));
            if (!b) {
                prefs.setLastFrameClosed("plot");
            }
        }
        super.setVisible(b);
    }

    public void doLayout() {
        Dimension asize = this.content.getSize();
        Dimension minsize = this.content.getMinimumSize();
        Dimension maxsize = this.content.getMaximumSize();
        if (asize.width != 0 && asize.height != 0) {
            if (asize.width < minsize.width || asize.height < minsize.height) {
                asize.width = Math.max(asize.width, minsize.width) + this.dwidth;
                asize.height = Math.max(asize.height, minsize.height) + this.dheight;
                this.setSize(asize);
            } else if (asize.width > maxsize.width || asize.height > maxsize.height) {
                asize.width = Math.min(asize.width, maxsize.width) + this.dwidth;
                asize.height = Math.min(asize.height, maxsize.height) + this.dheight;
                this.setSize(asize);
            }
        }
        super.doLayout();
    }

    public void print() {
        PrinterJob pj = PrinterJob.getPrinterJob();
        pj.setPrintable(this);
        if (pj.printDialog()) {
            try {
                pj.print();
            }
            catch (Exception PrintException) {
                PrintException.printStackTrace();
            }
        }
    }

    public int print(Graphics g, PageFormat pf, int page) {
        if (page > 0) {
            return 1;
        }
        BufferedImage src = ((M24DisplayPanel)((Object)this.content)).getImage();
        double srcWidth = ((Image)src).getWidth(this);
        double srcHeight = ((Image)src).getHeight(this);
        double scale = Math.min(Math.min(1.0, pf.getImageableWidth() / srcHeight), Math.min(1.0, pf.getImageableHeight() / srcWidth));
        double xMargin = 0.5 * (pf.getImageableWidth() - scale * srcHeight);
        double yMargin = 0.5 * (pf.getImageableHeight() - scale * srcWidth);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.translate(pf.getImageableX() + pf.getImageableWidth() - xMargin, pf.getImageableY() + yMargin);
        g2d.rotate(1.5707963267948966);
        g2d.scale(scale, scale);
        g2d.drawImage((Image)src, 0, 0, this);
        return 0;
    }

    public BufferedImage getImage() {
        return ((M24DisplayPanel)((Object)this.content)).getImage();
    }

    public void settingChanged(PreferencesEvent e) {
        this.updateSetting(e.getName());
    }

    private void updateSetting(String pname) {
        int whereY;
        int whereX;
        if (pname == null) {
            pname = "all";
        }
        boolean changeAll = pname.equals("all");
        if (this.content instanceof M24TimePanel && (changeAll || pname.equals("timeFrame_leftEdge") || pname.equals("timeFrame_topEdge"))) {
            whereX = prefs.getInt("timeFrame_leftEdge");
            whereY = prefs.getInt("timeFrame_topEdge");
            if (whereX >= 0 && whereY >= 0) {
                this.where = new Point(whereX, whereY);
            }
        }
        if (this.content instanceof M24PlotPanel) {
            if (changeAll || pname.equals("plotFrame_content")) {
                String choice = prefs.getString("plotFrame_content");
                if (choice.toLowerCase().indexOf("orbit") > -1) {
                    this.setTitle("Mars24 - Orbits");
                } else if (choice.toLowerCase().indexOf("path") > -1 || choice.toLowerCase().indexOf("panorama") > -1) {
                    this.setTitle("Mars24 - Local Panorama");
                } else {
                    this.setTitle("Mars24 - Sunclock");
                }
            }
            if (changeAll || pname.equals("plotFrame_leftEdge") || pname.equals("plotFrame_topEdge")) {
                whereX = prefs.getInt("plotFrame_leftEdge");
                whereY = prefs.getInt("plotFrame_topEdge");
                if (whereX >= 0 && whereY >= 0) {
                    this.where = new Point(whereX, whereY);
                }
            }
        }
    }
}

