/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24;

import gov.nasa.giss.gui.QuickBox;
import gov.nasa.giss.mars24.M24AnalemmaControls;
import gov.nasa.giss.mars24.M24EarthTimeControls;
import gov.nasa.giss.mars24.M24Globals;
import gov.nasa.giss.mars24.M24MarsTimeControls;
import gov.nasa.giss.mars24.M24PanoramaControls;
import gov.nasa.giss.mars24.M24PlotPanel;
import gov.nasa.giss.mars24.M24Preferences;
import gov.nasa.giss.mars24.M24SunclockControls;
import gov.nasa.giss.mars24.M24TimePanel;
import gov.nasa.giss.prefs.PreferencesEvent;
import gov.nasa.giss.prefs.PreferencesListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;

public class M24ControlsPanel
extends JPanel
implements PreferencesListener,
MouseListener {
    private M24Preferences prefs;
    private M24PlotPanel plotDisplay;
    private M24TimePanel timeDisplay;
    private JComboBox displayMenu;
    private JPanel currentDisplay;
    private JPanel plotControls;
    private JPanel orbitControls;
    private M24EarthTimeControls earthTimeControls;
    private M24MarsTimeControls marsTimeControls;
    private M24SunclockControls sunclockControls;
    private M24PanoramaControls panoramaControls;
    private M24AnalemmaControls analemmaControls;
    private JPopupMenu plotPopup = null;
    private JPopupMenu timePopup = null;

    public M24ControlsPanel() {
        throw new IllegalArgumentException("Use another constructor");
    }

    public M24ControlsPanel(M24PlotPanel p1, M24TimePanel p2) {
        if (p1 == null) {
            throw new IllegalArgumentException("Plot panel cannot be null");
        }
        if (p2 == null) {
            throw new IllegalArgumentException("Time panel cannot be null");
        }
        this.plotDisplay = p1;
        this.timeDisplay = p2;
        this.prefs = M24Globals.getSettings();
        this.earthTimeControls = new M24EarthTimeControls(this.plotDisplay, this.timeDisplay);
        this.marsTimeControls = new M24MarsTimeControls(this.plotDisplay, this.timeDisplay);
        this.plotControls = this.createPlotControls();
        M24Globals.reduceContainerFonts(this.earthTimeControls, 2);
        M24Globals.reduceContainerFonts(this.marsTimeControls, 2);
        M24Globals.reduceContainerFonts(this.plotControls, 2);
        this.earthTimeControls.setBorder(M24Globals.createPaddedTitleBorder("Earth"));
        this.marsTimeControls.setBorder(M24Globals.createPaddedTitleBorder("Mars"));
        JPanel timeControls = new JPanel();
        timeControls.setLayout(new BoxLayout(timeControls, 1));
        timeControls.add(this.earthTimeControls);
        timeControls.add(Box.createVerticalStrut(6));
        timeControls.add(this.marsTimeControls);
        timeControls.add(Box.createVerticalGlue());
        JTabbedPane mainTPane = new JTabbedPane(1);
        mainTPane.setName("[main tpane]");
        mainTPane.addTab("Time", timeControls);
        mainTPane.addTab("Plot", this.plotControls);
        mainTPane.setMaximumSize(mainTPane.getPreferredSize());
        mainTPane.setMinimumSize(mainTPane.getPreferredSize());
        this.setAll();
        this.add(mainTPane);
        this.plotDisplay.addMouseListener(this);
        this.timeDisplay.addMouseListener(this);
        this.prefs.addSettingsListener(this);
    }

    private JPanel createPlotControls() {
        this.displayMenu = new JComboBox<String>(M24PlotPanel.DISPLAY_CHOICES);
        this.displayMenu.setMaximumSize(this.displayMenu.getPreferredSize());
        this.displayMenu.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                String choice = (String)M24ControlsPanel.this.displayMenu.getSelectedItem();
                M24ControlsPanel.this.prefs.set("plotFrame_content", choice);
                M24ControlsPanel.this.plotControls.remove(M24ControlsPanel.this.currentDisplay);
                if (choice.equals("Orbital Position")) {
                    M24ControlsPanel.this.currentDisplay = M24ControlsPanel.this.orbitControls;
                } else if (choice.equals("Local Panorama")) {
                    M24ControlsPanel.this.currentDisplay = M24ControlsPanel.this.panoramaControls;
                } else if (choice.equals("Analemma")) {
                    M24ControlsPanel.this.currentDisplay = M24ControlsPanel.this.analemmaControls;
                } else {
                    M24ControlsPanel.this.currentDisplay = M24ControlsPanel.this.sunclockControls;
                }
                M24ControlsPanel.this.plotControls.add(M24ControlsPanel.this.currentDisplay);
                M24ControlsPanel.this.plotControls.revalidate();
                M24ControlsPanel.this.plotControls.repaint();
                JFrame f = (JFrame)M24ControlsPanel.this.getTopLevelAncestor();
                if (f != null) {
                    f.pack();
                }
            }
        });
        this.sunclockControls = new M24SunclockControls(this.plotDisplay, this.timeDisplay);
        this.panoramaControls = new M24PanoramaControls(this.plotDisplay, this.timeDisplay);
        this.orbitControls = this.createOrbitControls();
        this.analemmaControls = new M24AnalemmaControls();
        this.currentDisplay = this.sunclockControls;
        int pWidth = this.sunclockControls.getPreferredSize().width;
        pWidth = Math.max(pWidth, this.orbitControls.getPreferredSize().width);
        pWidth = Math.max(pWidth, this.panoramaControls.getPreferredSize().width);
        int pHeight = this.sunclockControls.getPreferredSize().height;
        pHeight = Math.max(pHeight, this.orbitControls.getPreferredSize().height);
        pHeight = Math.max(pHeight, this.panoramaControls.getPreferredSize().height);
        Dimension size = new Dimension(pWidth, pHeight);
        this.sunclockControls.setPreferredSize(size);
        this.sunclockControls.setMinimumSize(size);
        this.sunclockControls.setMaximumSize(size);
        this.orbitControls.setPreferredSize(size);
        this.orbitControls.setMinimumSize(size);
        this.orbitControls.setMaximumSize(size);
        this.panoramaControls.setPreferredSize(size);
        this.panoramaControls.setMinimumSize(size);
        this.panoramaControls.setMaximumSize(size);
        QuickBox menuBox = QuickBox.createHorizontalBox(0, new Component[]{new JLabel("Show: "), this.displayMenu});
        JPanel panel = new JPanel();
        panel.setBorder(M24Globals.STANDARD_BORDER);
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(menuBox);
        panel.add(Box.createVerticalStrut(6));
        panel.add(this.currentDisplay);
        return panel;
    }

    private JPanel createOrbitControls() {
        JPanel panel = new JPanel();
        panel.setBorder(M24Globals.createPaddedTitleBorder("Display Options"));
        JLabel msg = new JLabel("There are no options for this display.");
        panel.add(msg);
        return panel;
    }

    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger() && e.getSource() instanceof M24PlotPanel) {
            this.handlePlotPopup(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger() && e.getSource() instanceof M24PlotPanel) {
            this.handlePlotPopup(e);
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (e.isPopupTrigger()) {
            if (e.getSource() instanceof M24PlotPanel) {
                this.handlePlotPopup(e);
            }
        } else if (e.getSource() instanceof M24PlotPanel) {
            if (!e.isShiftDown() && !e.isAltDown()) {
                return;
            }
            Point2D.Double pd = this.plotDisplay.transformXY2LL(e.getX(), e.getY());
            if (pd == null) {
                return;
            }
            pd.x = 0.05 * (double)((int)(pd.x * 20.0));
            pd.y = 0.05 * (double)((int)(pd.y * 20.0));
            if (pd.x < 0.0) {
                pd.x += 360.0;
            }
            if (e.isShiftDown()) {
                try {
                    this.prefs.set("sunclock_copLon", new Double(pd.x));
                    this.prefs.set("sunclock_copLat", new Double(pd.y));
                }
                catch (Exception exc) {
                    System.out.println("double error");
                }
                this.prefs.set("sunclock_copType", "lonlat");
                this.sunclockControls.setCenterOfProjection(pd.x, pd.y);
            } else if (e.isAltDown()) {
                try {
                    this.prefs.set("marsTime_spotLon", new Double(pd.x));
                    this.prefs.set("marsTime_spotLat", new Double(pd.y));
                }
                catch (Exception exc) {
                    System.out.println("double error");
                }
                this.marsTimeControls.setTimeSpot(pd.x, pd.y);
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void handlePlotPopup(MouseEvent e) {
        if (!(e.getSource() instanceof M24PlotPanel) || !e.isPopupTrigger()) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        this.plotPopup = new JPopupMenu();
        for (int i = 0; i < M24PlotPanel.DISPLAY_CHOICES.length; ++i) {
            final int ix = i;
            JMenuItem item = new JMenuItem(M24PlotPanel.DISPLAY_CHOICES[i]);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    M24ControlsPanel.this.displayMenu.setSelectedIndex(ix);
                }
            });
            this.plotPopup.add(item);
        }
        if (((String)this.displayMenu.getSelectedItem()).equals("Sunclock Map")) {
            this.plotPopup.addSeparator();
            final Point2D.Double pd = this.plotDisplay.transformXY2LL(x, y);
            JMenuItem recenter = new JMenuItem("Set Center");
            if (pd == null) {
                recenter.setEnabled(false);
            } else {
                pd.x = 0.05 * (double)((int)(pd.x * 20.0));
                pd.y = 0.05 * (double)((int)(pd.y * 20.0));
                if (pd.x < 0.0) {
                    pd.x += 360.0;
                }
                recenter.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ee) {
                        try {
                            M24ControlsPanel.this.prefs.set("sunclock_copLon", new Double(pd.x));
                            M24ControlsPanel.this.prefs.set("sunclock_copLat", new Double(pd.y));
                        }
                        catch (Exception exc) {
                            System.out.println("double error");
                        }
                        M24ControlsPanel.this.prefs.set("sunclock_copType", "lonlat");
                        M24ControlsPanel.this.sunclockControls.setCenterOfProjection(pd.x, pd.y);
                    }
                });
            }
            this.plotPopup.add(recenter);
            JMenuItem setSite = new JMenuItem("Set Time Point");
            if (pd == null) {
                setSite.setEnabled(false);
            } else {
                setSite.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ee) {
                        try {
                            M24ControlsPanel.this.prefs.set("marsTime_spotLon", new Double(pd.x));
                            M24ControlsPanel.this.prefs.set("marsTime_spotLat", new Double(pd.y));
                        }
                        catch (Exception exc) {
                            System.out.println("double error");
                        }
                        M24ControlsPanel.this.marsTimeControls.setTimeSpot(pd.x, pd.y);
                    }
                });
            }
            this.plotPopup.add(setSite);
        }
        this.plotPopup.show(e.getComponent(), x, y);
    }

    public void handleTimePopup(MouseEvent e) {
    }

    public void settingChanged(PreferencesEvent e) {
        if (e.getName().equals("all")) {
            this.setAll();
        }
    }

    private void setAll() {
        String choice = this.prefs.getString("plotFrame_content");
        this.displayMenu.setSelectedItem(choice);
        this.plotControls.remove(this.currentDisplay);
        this.currentDisplay = choice.equals("Orbital Position") ? this.orbitControls : (choice.equals("Local Panorama") ? this.panoramaControls : (choice.equals("Analemma") ? this.analemmaControls : this.sunclockControls));
        this.plotControls.add(this.currentDisplay);
        this.earthTimeControls.setAll();
        this.marsTimeControls.setAll();
        this.sunclockControls.setAll();
        this.panoramaControls.setAll();
        JFrame f = (JFrame)this.getTopLevelAncestor();
        if (f != null && f.isVisible()) {
            this.plotControls.revalidate();
            this.plotControls.repaint();
            f.pack();
        }
    }
}

