/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24;

import gov.nasa.giss.mars24.M24ControlsPanel;
import gov.nasa.giss.mars24.M24Globals;
import gov.nasa.giss.mars24.M24Menubar;
import gov.nasa.giss.mars24.M24Preferences;
import gov.nasa.giss.mars24.M24WindowMenu;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;

public class M24ControlsFrame
extends JFrame {
    private M24Preferences prefs = M24Globals.getSettings();

    public M24ControlsFrame(M24ControlsPanel panel) {
        this.setTitle("Mars24 Settings");
        this.setName("controls");
        this.setResizable(false);
        this.setDefaultCloseOperation(1);
        this.setJMenuBar(new M24Menubar(this));
        this.getContentPane().add(panel);
        this.pack();
        Point where = null;
        int whereX = this.prefs.getInt("controlsFrame_leftEdge");
        int whereY = this.prefs.getInt("controlsFrame_topEdge");
        if (whereX >= 0 && whereY >= 0) {
            where = new Point(whereX, whereY);
        }
        if (where == null) {
            Rectangle rr = M24Globals.getMainScreenBounds();
            if (rr == null) {
                where = new Point(100, 100);
            } else {
                Dimension psize = this.getContentPane().getPreferredSize();
                where = new Point(rr.x + rr.width - psize.width - 50, rr.y + rr.height - psize.height - 50);
            }
        }
        this.setLocation(where);
        this.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent e) {
                if (!M24ControlsFrame.this.isVisible()) {
                    return;
                }
                Point p = M24ControlsFrame.this.getLocationOnScreen();
                M24ControlsFrame.this.prefs.setInt("controlsFrame_leftEdge", p.x);
                M24ControlsFrame.this.prefs.setInt("controlsFrame_topEdge", p.y);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                ((M24WindowMenu)((M24Menubar)M24ControlsFrame.this.getJMenuBar()).getMenu("Window")).update();
                M24ControlsFrame.this.prefs.setBoolean("controlsFrame_visible", true);
            }

            public void windowClosed(WindowEvent e) {
                M24ControlsFrame.this.prefs.setBoolean("controlsFrame_visible", false);
            }

            public void windowClosing(WindowEvent e) {
                M24ControlsFrame.this.prefs.setBoolean("controlsFrame_visible", false);
                M24ControlsFrame.this.prefs.setLastFrameClosed("controls");
            }
        });
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        this.prefs.set("controlsFrame_visible", new Boolean(b));
        if (!b) {
            this.prefs.setLastFrameClosed("controls");
        }
    }
}

