/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24;

import gov.nasa.giss.mars24.M24Globals;
import gov.nasa.giss.mars24.M24Preferences;
import gov.nasa.giss.mars24.M24Timekeeper;
import gov.nasa.giss.mars24.M24TimekeeperEvent;
import gov.nasa.giss.mars24.M24TimekeeperListener;
import gov.nasa.giss.prefs.PreferencesEvent;
import gov.nasa.giss.prefs.PreferencesListener;
import gov.nasa.giss.time.AbstractPlanetTime;
import gov.nasa.giss.time.MarsTime;
import gov.nasa.giss.time.TimeConstants;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import javax.swing.JComponent;

public class M24AnalemmaPanel
extends JComponent
implements TimeConstants,
PreferencesListener,
M24TimekeeperListener {
    private static final long REFRESH_INTERVAL = 300000L;
    private static final long SOL_MILLIS = 88775244L;
    private static final long HALF_SOL_MILLIS = 44387622L;
    private static final long MARS_HOUR_MILLIS = 3698968L;
    private static final long MARS_DEG_MILLIS = 246597L;
    private static final double EPSILON_HOURS = 5.0E-7;
    private static final Color MARS_COLOR = Color.red;
    private static final Color MARKS_COLOR = Color.white;
    private static final BasicStroke THIN_STROKE = new BasicStroke(1.0f);
    private M24Timekeeper timekeeper;
    private M24Preferences prefs;
    private MarsTime tmTime = new MarsTime();
    private long lastUpdate;
    private long now = System.currentTimeMillis();
    private int fheightTicks = 20;
    private int fheightLs = 20;
    private Font fontTicks = new Font("Courier", 0, this.fheightTicks);
    private Font fontLs = new Font("Courier", 0, this.fheightLs);
    private boolean showLsLabels = false;
    private double yRatio;
    private double xRatio;

    public M24AnalemmaPanel(Dimension max) {
        this.timekeeper = M24Globals.getTimekeeper();
        this.prefs = M24Globals.getSettings();
        this.setDoubleBuffered(true);
        this.setOpaque(true);
        this.setMaximumSize(max);
        this.setBackground(Color.black);
        this.timekeeper.addTimekeeperListener(this);
        this.prefs.addSettingsListener(this);
        this.updateSetting("all");
    }

    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    public void setSize(int w, int h) {
        super.setSize(w, h);
        this.fheightTicks = Math.max(h / 50, 8);
        this.fheightLs = Math.max(h / 100, 6);
        this.fontTicks = new Font("Courier", 0, this.fheightTicks);
        this.fontLs = new Font("Courier", 0, this.fheightLs);
    }

    public void paintComponent(Graphics g) {
        if (!this.isVisible()) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        Dimension d = this.getSize();
        int tWidth = d.width / 2;
        int tHeight = d.height / 2;
        this.yRatio = 0.9 * (double)tHeight / 25.0;
        this.xRatio = this.yRatio * 25.0;
        g2d.setColor(this.getBackground());
        g2d.fillRect(0, 0, d.width, d.height);
        g2d.setFont(this.fontTicks);
        FontMetrics fm = g.getFontMetrics();
        g2d.setColor(Color.white);
        g2d.drawLine(0, tHeight, d.width, tHeight);
        g2d.drawLine(tWidth, 0, tWidth, d.height);
        g2d.translate(tWidth, tHeight);
        for (int i = 0; i < 91; i += 5) {
            int y = (int)((double)i * this.yRatio);
            g2d.setColor(Color.white);
            g2d.drawLine(-5, y, 5, y);
            g2d.drawLine(-5, -y, 5, -y);
            if (i == 0) continue;
            g2d.setColor(Color.gray);
            g.drawString(-i + "\u00b0", 7, y + this.fheightTicks / 3);
            g.drawString(i + "\u00b0", 7, -y + this.fheightTicks / 3);
        }
        for (int i = 0; i < 101; i += 10) {
            int x = (int)((double)i * this.xRatio / 60.0);
            g2d.setColor(Color.white);
            g2d.drawLine(x, -5, x, 5);
            g2d.drawLine(-x, -5, -x, 5);
            if (i == 0 || i % 20 != 0) continue;
            g2d.setColor(Color.gray);
            String s1 = -i + "";
            String s2 = i + "";
            int len1 = fm.stringWidth(s1);
            int len2 = fm.stringWidth(s2);
            g.drawString(s1, -x - len1 / 2, 5 + this.fheightTicks);
            g.drawString(s2, x - len2 / 2, 5 + this.fheightTicks);
        }
        AbstractPlanetTime mTime = this.timekeeper.getTimeObject(4);
        double lon = this.timekeeper.getSiteLongitude();
        double lat = this.timekeeper.getSiteLatitude();
        long millis = this.timekeeper.getMillis();
        int highIter = 0;
        long highMillis = millis;
        while (highIter < 25) {
            double dHours;
            ++highIter;
            this.tmTime.setTime(highMillis);
            for (dHours = 12.0 - this.tmTime.getTimeHours(lon, 1); dHours > 12.0; dHours -= 24.0) {
            }
            while (dHours <= -12.0) {
                dHours += 24.0;
            }
            if (Math.abs(dHours) < 5.0E-7) break;
            highMillis += (long)(3698968.0 * dHours);
        }
        this.markLs(g2d, Color.red, true);
        for (int i = 10; i <= 668; i += 10) {
            highMillis = (long)((double)highMillis + 8.8775244E8);
            this.tmTime.setTime(highMillis);
            this.markLs(g2d, Color.white, i % 20 == 0);
        }
        g2d.translate(-tWidth, -tHeight);
        this.lastUpdate = this.now;
    }

    private void markLs(Graphics2D g2d, Color c, boolean b) {
        double elevation = this.tmTime.getSolarDeclination(1);
        double eot = this.tmTime.getEOTHours();
        double x = eot * this.xRatio;
        double y = -elevation * this.yRatio;
        g2d.setColor(c);
        g2d.fill(new Ellipse2D.Double(x - 3.0, y - 3.0, 6.0, 6.0));
        if (b && this.showLsLabels) {
            g2d.setColor(Color.gray);
            double ls = this.tmTime.getSolarLongitude();
            String s = "Ls" + M24Globals.FORMAT_X1.format(ls);
            int len = g2d.getFontMetrics().stringWidth(s);
            if (ls <= 90.0) {
                g2d.drawString(s, (int)x - 5 - len, (int)y - 2);
            } else if (ls <= 180.0) {
                g2d.drawString(s, (int)x + 5, (int)y - 2);
            } else if (ls <= 270.0) {
                g2d.drawString(s, (int)x + 5, (int)y + this.fheightLs + 2);
            } else {
                g2d.drawString(s, (int)x - 5 - len, (int)y + this.fheightLs + 2);
            }
        }
    }

    public String getName() {
        return "Mars Analemma";
    }

    public void timeChanged(M24TimekeeperEvent e) {
        if (!this.isVisible()) {
            return;
        }
        this.now = System.currentTimeMillis();
        if (this.now - this.lastUpdate < 300000L) {
            return;
        }
        this.repaint();
        this.lastUpdate = this.now;
    }

    public void timeReset(M24TimekeeperEvent e) {
        this.lastUpdate = 0L;
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public void siteChanged(M24TimekeeperEvent e) {
    }

    public void formatChanged(M24TimekeeperEvent e) {
    }

    public void settingChanged(PreferencesEvent e) {
        this.updateSetting(e.getName());
    }

    private void updateSetting(String pname) {
        this.lastUpdate = 0L;
        if (pname == null || pname.equals("all")) {
            this.updateSetting("analemma_lsLabels");
        }
        if (pname.equals("analemma_lsLabels")) {
            try {
                this.showLsLabels = this.prefs.getBoolean("analemma_lsLabels");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.isVisible()) {
            this.repaint();
        }
    }
}

