/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24;

import gov.nasa.giss.mars24.M24Globals;
import gov.nasa.giss.mars24.M24Preferences;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import net.schmunk.gui.FGConstraint;
import net.schmunk.gui.FlexingGridLayout;

public class M24AnalemmaControls
extends JPanel {
    private M24Preferences prefs;
    private JCheckBox showLsCB = new JCheckBox("Show Ls Labels", true);

    public M24AnalemmaControls() {
        this.prefs = M24Globals.getSettings();
        FlexingGridLayout fgl = new FlexingGridLayout(new Dimension(3, 2), 2, 2);
        fgl.setColumnWeight(2, 100.0f);
        fgl.setRowWeight(1, 100.0f);
        this.setLayout(fgl);
        this.setBorder(M24Globals.createPaddedTitleBorder("Analemma Options"));
        this.add((Component)this.showLsCB, new FGConstraint(new Rectangle(0, 0, 1, 1), 0.0, 0.5));
        this.add(Box.createVerticalGlue(), new FGConstraint(new Rectangle(0, 1, 1, 1), 0.0, 0.5));
        this.showLsCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Boolean value = new Boolean(M24AnalemmaControls.this.showLsCB.isSelected());
                M24AnalemmaControls.this.prefs.set("analemma_lsLabels", value);
            }
        });
    }

    public void setAll() {
        try {
            this.showLsCB.setSelected(this.prefs.getBoolean("analemma_lsLabels"));
        }
        catch (Exception exc) {
            this.showLsCB.setSelected(false);
        }
    }
}

