/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24;

import gov.nasa.giss.mars24.M24ControlsPanel;
import gov.nasa.giss.mars24.M24PlotPanel;
import gov.nasa.giss.mars24.M24TimePanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;

public class M24AllInOnePanel
extends JPanel {
    private M24PlotPanel plot;
    private M24TimePanel time;
    private M24ControlsPanel controls;

    public M24AllInOnePanel(M24PlotPanel p1, M24TimePanel p2, M24ControlsPanel p3) {
        this(p1, p2, p3, 1280, 600);
    }

    public M24AllInOnePanel(M24PlotPanel p1, M24TimePanel p2, M24ControlsPanel p3, int w, int h) {
        this.plot = p1;
        this.time = p2;
        this.controls = p3;
        Dimension d = new Dimension(w, h);
        this.setBackground(Color.black);
        this.setBorder(null);
        this.setOpaque(true);
        this.setLayout(null);
        this.add(this.plot);
        this.add(this.time);
        this.add(this.controls);
        this.setMaximumSize(d);
        this.setMinimumSize(d);
        this.setPreferredSize(d);
        this.setSize(d);
    }

    public void paintComponent(Graphics g) {
        Dimension d = this.getSize();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, d.width, d.height);
    }

    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    public void setSize(int w, int h) {
        super.setSize(w, h);
        Dimension dsize = this.getSize();
        Dimension csize = this.controls.getPreferredSize();
        System.out.println("controls " + csize);
        if (w > h) {
            this.controls.setLocation(0, 0);
            this.controls.setSize(csize.width, dsize.height);
            int plotwidth = dsize.width - csize.width;
            int plotheight = plotwidth * 57 / 100;
            int timeheight = dsize.height - plotheight;
            if (timeheight < plotwidth / 7) {
                timeheight = plotwidth / 7;
                plotheight = dsize.height - timeheight;
            }
            this.plot.setLocation(csize.width, 0);
            this.plot.setSize(plotwidth, plotheight);
            this.time.setLocation(csize.width, plotheight);
            this.time.setSize(plotwidth, timeheight);
        } else {
            int plotwidth = dsize.width;
            int plotheight = dsize.height - csize.height;
            int timeWidth = dsize.width - csize.width;
            int timeheight = csize.height;
            this.plot.setLocation(0, 0);
            this.plot.setSize(plotwidth, plotheight);
            this.controls.setLocation(0, plotheight);
            this.controls.setSize(csize);
            this.time.setLocation(csize.width, plotheight);
            this.time.setSize(timeWidth, timeheight);
        }
    }
}

