/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mars24;

import gov.nasa.giss.gui.JMultiLineLabel;
import gov.nasa.giss.mars24.M24Globals;
import gov.nasa.giss.mars24.M24HelpFrame;
import gov.nasa.giss.mars24.M24Menubar;
import gov.nasa.giss.mars24.M24WindowMenu;
import gov.nasa.giss.xml.XmlPropertiesBundle;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

class M24AboutFrame
extends JFrame {
    private static M24AboutFrame aboutFrame;
    private static Font bold14;
    private static Font plain12;
    private static Font plain11;
    private static Font plain10;
    private static Font plain9;
    private static Font plain8;
    private JMenuBar mbar;
    private boolean launched = false;

    public static void reveal() {
        aboutFrame = M24AboutFrame.find();
        if (aboutFrame.isVisible()) {
            aboutFrame.toFront();
            return;
        }
        aboutFrame.setVisible(true);
    }

    public static M24AboutFrame find() {
        if (aboutFrame == null) {
            aboutFrame = new M24AboutFrame();
        }
        return aboutFrame;
    }

    private M24AboutFrame() {
        XmlPropertiesBundle aboutProperties;
        if (M24Globals.isApplicationContext()) {
            this.mbar = new M24Menubar(this);
        }
        if ((aboutProperties = new XmlPropertiesBundle("gov.nasa.giss.mars24.resources.AboutMars24")) == null) {
            System.out.println("null properties bundle");
            return;
        }
        this.setResizable(false);
        this.setTitle(aboutProperties.getString("aboutTitle"));
        JLabel appIcon = null;
        try {
            Image img = M24Globals.loadImage(this.getClass().getResourceAsStream("resources/mars24.png"));
            appIcon = new JLabel(new ImageIcon(img));
            appIcon.setAlignmentX(0.5f);
        }
        catch (Exception exc) {
            // empty catch block
        }
        JLabel titleLabel = new JLabel(aboutProperties.getString("appName"), 0);
        titleLabel.setFont(bold14);
        titleLabel.setAlignmentX(0.5f);
        JLabel versionLabel = new JLabel(aboutProperties.getString("version-word") + " " + aboutProperties.getString("version"), 0);
        versionLabel.setFont(plain11);
        versionLabel.setAlignmentX(0.5f);
        JLabel buildLabel = new JLabel("(" + aboutProperties.getString("build-word") + " " + aboutProperties.getString("build") + ")", 0);
        buildLabel.setFont(plain9);
        buildLabel.setAlignmentX(0.5f);
        JMultiLineLabel authorLabel = new JMultiLineLabel(aboutProperties.getString("author"), 0);
        authorLabel.setFont(plain11);
        authorLabel.setAlignmentX(0.5f);
        JMultiLineLabel webinfoLabel = new JMultiLineLabel(aboutProperties.getString("webinfo"), 0);
        webinfoLabel.setFont(plain11);
        final String url = aboutProperties.getString("url");
        webinfoLabel.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                int clicks = e.getClickCount();
                if (clicks < 2) {
                    return;
                }
                try {
                    M24HelpFrame.displayURL(new URL(url));
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
        JLabel gissLabel = new JLabel("NASA GISS", 0);
        gissLabel.setFont(bold14);
        gissLabel.setAlignmentX(0.5f);
        gissLabel.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                int clicks = e.getClickCount();
                if (clicks < 2) {
                    return;
                }
                try {
                    M24HelpFrame.displayURL(new URL("http://www.giss.nasa.gov/"));
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
        JLabel javaLabel = new JLabel("(Java " + System.getProperty("java.version") + ")", 0);
        javaLabel.setFont(plain8);
        javaLabel.setAlignmentX(0.5f);
        Box contentBox = Box.createVerticalBox();
        if (appIcon != null) {
            contentBox.add(appIcon);
            contentBox.add(Box.createVerticalStrut(8));
        }
        contentBox.add(titleLabel);
        contentBox.add(Box.createVerticalStrut(8));
        contentBox.add(versionLabel);
        contentBox.add(buildLabel);
        contentBox.add(Box.createVerticalStrut(8));
        contentBox.add(authorLabel);
        contentBox.add(Box.createVerticalStrut(8));
        contentBox.add(webinfoLabel);
        contentBox.add(Box.createVerticalStrut(8));
        contentBox.add(gissLabel);
        contentBox.add(Box.createVerticalStrut(8));
        contentBox.add(javaLabel);
        JPanel contentPanel = new JPanel();
        contentPanel.add(contentBox);
        contentPanel.setBorder(M24Globals.STANDARD_BORDER);
        this.getContentPane().add(contentPanel);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                if (M24AboutFrame.this.getJMenuBar() == null) {
                    return;
                }
                ((M24WindowMenu)((M24Menubar)M24AboutFrame.this.getJMenuBar()).getMenu("Window")).update();
            }

            public void windowClosed(WindowEvent e) {
            }

            public void windowClosing(WindowEvent e) {
            }
        });
        this.pack();
        Rectangle rr = M24Globals.getMainScreenBounds();
        if (rr == null) {
            this.setLocation(25, 25);
        } else {
            Dimension psize = this.getContentPane().getPreferredSize();
            int x = (rr.width - psize.width) / 2;
            int y = (rr.height - psize.height) / 2;
            this.setLocation(rr.x + x, rr.y + y);
        }
    }

    public void setLaunched(boolean b) {
        this.launched = b;
    }

    public void setVisible(boolean b) {
        if (this.launched && this.getJMenuBar() == null) {
            if (M24Globals.isApplicationContext()) {
                this.setJMenuBar(this.mbar);
            }
            this.pack();
        }
        super.setVisible(b);
    }

    static {
        UIDefaults uid = UIManager.getDefaults();
        Font f = uid.getFont("Label.font");
        if (f != null) {
            int adjust = 12 - f.getSize();
            plain12 = f.deriveFont((float)(f.getSize() + adjust));
            bold14 = plain12.deriveFont(1, plain12.getSize() + 2);
            plain11 = plain12.deriveFont((float)(plain12.getSize() - 1));
            plain10 = plain12.deriveFont((float)(plain12.getSize() - 2));
            plain9 = plain12.deriveFont((float)(plain12.getSize() - 3));
            plain8 = plain12.deriveFont((float)(plain12.getSize() - 4));
        } else {
            bold14 = new Font("SansSerif", 1, 14);
            plain12 = new Font("SansSerif", 0, 12);
            plain11 = new Font("SansSerif", 0, 11);
            plain10 = new Font("SansSerif", 0, 10);
            plain9 = new Font("SansSerif", 0, 9);
            plain8 = new Font("SansSerif", 0, 8);
        }
    }
}

