/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.FlatPoleProjection;
import gov.nasa.giss.mapping.proj.ProjectionBooleanParameter;
import gov.nasa.giss.mapping.proj.ProjectionExtraParameter;
import java.awt.geom.Point2D;

public class WinkelTripel
extends FlatPoleProjection {
    private static final String PROJECTION_NAME = "Winkel Tripel";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double COS_PHI0 = 0.6366197723675814;
    private static final double COS_PHI0_B = Math.cos(WinkelTripel.toRadians(40.0));
    private static final double WIDTH_FACTOR = 0.5 * (Math.PI + Math.PI * COS_PHI0_B);
    private static final double HEIGHT_FACTOR = 1.5707963267948966;
    private static final double ASPECT_RATIO = WIDTH_FACTOR / 1.5707963267948966;
    private double cosPhi0 = 0.6366197723675814;

    public WinkelTripel(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public WinkelTripel(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public WinkelTripel(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, WIDTH_FACTOR, 1.5707963267948966, dw, dh, xm, ym);
        this.setExtraParameters(new ProjectionExtraParameter[]{new ProjectionBooleanParameter("Use Bartholomew Option", false)});
        this.extraParameterChanged();
    }

    public void extraParameterChanged() {
        ProjectionBooleanParameter p = (ProjectionBooleanParameter)this.getParameter(1);
        this.cosPhi0 = p.isSelected() ? COS_PHI0_B : 0.6366197723675814;
        this.fitToTarget();
        this.needsUpdate = true;
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    protected void calculateInverseArray() {
        this.clearInverseArray();
        block0: for (int iy = 0; iy < this.dstMax.y; ++iy) {
            double y = (double)iy + 0.5;
            double phiRad = this.oneOverRS * y;
            double lambdaRad = 0.0;
            for (int ix = 0; ix < this.dstMax.x; ++ix) {
                double x = (double)ix + 0.5;
                phiRad += 1.0E-5;
                lambdaRad += 1.0E-5;
                for (int iter = 0; iter < 25; ++iter) {
                    double halfLambdaRad = 0.5 * lambdaRad;
                    double cosPhi = Math.cos(phiRad);
                    double sinPhi = Math.sin(phiRad);
                    double sin2Phi = Math.sin(2.0 * phiRad);
                    double cosSquPhi = cosPhi * cosPhi;
                    double sinSquPhi = sinPhi * sinPhi;
                    double cosLambda = Math.cos(lambdaRad);
                    double sinLambda = Math.sin(lambdaRad);
                    double cosHalfLambda = Math.cos(halfLambdaRad);
                    double sinHalfLambda = Math.sin(halfLambdaRad);
                    double cosD = cosPhi * Math.cos(halfLambdaRad);
                    double d = Math.acos(cosD);
                    double c = 1.0 - cosD * cosD;
                    double oneOverC = 1.0 / c;
                    double sqrtC = Math.sqrt(c);
                    double oneOverSqrtC = 1.0 / sqrtC;
                    double dOverCSqrtC = d / (c * sqrtC);
                    double df1dPhi = 0.25 * sinLambda * sin2Phi * oneOverC - dOverCSqrtC * sinPhi * sinHalfLambda;
                    double df1dLambda = 0.5 * (cosSquPhi * sinHalfLambda * sinHalfLambda * oneOverC + dOverCSqrtC * cosPhi * cosHalfLambda * sinSquPhi + this.cosPhi0);
                    double df2dPhi = 0.5 * (sinSquPhi * cosHalfLambda * oneOverC + dOverCSqrtC * (1.0 - cosHalfLambda * cosHalfLambda) * cosPhi + 1.0);
                    double df2dLambda = 0.125 * (sin2Phi * sinHalfLambda * oneOverC - dOverCSqrtC * sinPhi * cosSquPhi * sinLambda);
                    double f1 = 0.5 * (2.0 * d * cosPhi * sinHalfLambda * oneOverSqrtC + lambdaRad * this.cosPhi0) - x * this.oneOverRS;
                    double f2 = 0.5 * (d * sinPhi * oneOverSqrtC + phiRad) - y * this.oneOverRS;
                    double denom = df1dPhi * df2dLambda - df2dPhi * df1dLambda;
                    double dphiX = (f1 * df2dLambda - f2 * df1dLambda) / denom;
                    double lambdaX = (f2 * df1dPhi - f1 * df2dPhi) / denom;
                    phiRad -= dphiX;
                    lambdaRad -= lambdaX;
                    if (Math.abs(dphiX) < 1.0E-5 && Math.abs(lambdaX) < 1.0E-5) break;
                }
                if (lambdaRad > Math.PI) continue block0;
                this.setQSymmetricPoints(ix, iy, WinkelTripel.toDegrees(lambdaRad), WinkelTripel.toDegrees(phiRad));
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double lambdaRad = this.transformLon2LambdaRad(lon);
        double halfLambdaRad = 0.5 * lambdaRad;
        double phiRad = WinkelTripel.toRadians(lat);
        double cosPhi = Math.cos(phiRad);
        double d = Math.acos(cosPhi * Math.cos(halfLambdaRad));
        double x = 0.0;
        double y = 0.0;
        if (Math.abs(d) > 1.0E-5) {
            double dOverSinD = d / Math.sin(d);
            x = 0.5 * (lambdaRad * this.cosPhi0 + 2.0 * dOverSinD * cosPhi * Math.sin(halfLambdaRad));
            y = 0.5 * (phiRad + dOverSinD * Math.sin(phiRad));
        }
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

