/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.FlatPoleProjection;
import java.awt.geom.Point2D;

public class Winkel2
extends FlatPoleProjection {
    private static final String PROJECTION_NAME = "Winkel II";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double WIDTH_FACTOR = 2.5707963267948966;
    private static final double HEIGHT_FACTOR = 1.5707963267948966;
    public static final double ASPECT_RATIO = 1.6366197723675813;

    public Winkel2(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public Winkel2(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public Winkel2(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, 2.5707963267948966, 1.5707963267948966, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return 1.6366197723675813;
    }

    protected void calculateInverseArray() {
        double y;
        double phiRad;
        this.clearInverseArray();
        double twoPiOverRS = Math.PI * 2 * this.oneOverRS;
        for (int iy = 0; iy < this.dstMax.y && !((phiRad = (y = (double)iy + 0.5) * this.oneOverRS) > 1.5707963267948966); ++iy) {
            double x;
            double lambdaRad;
            double phi = Winkel2.toDegrees(phiRad);
            double xFactor = twoPiOverRS / (2.0 + Math.sqrt(Math.PI * Math.PI - 4.0 * phiRad * phiRad));
            for (int ix = 0; ix < this.dstMax.x && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, Winkel2.toDegrees(lambdaRad), phi);
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = Winkel2.toRadians(lat);
        double x = 0.5 * this.transformLon2LambdaRad(lon) * (0.6366197723675814 + Math.sqrt(Math.PI * Math.PI - 4.0 * phiRad * phiRad) * 0.3183098861837907);
        double y = phiRad;
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

