/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.FlatPoleProjection;
import gov.nasa.giss.mapping.proj.ProjectionDoubleParameter;
import gov.nasa.giss.mapping.proj.ProjectionExtraParameter;
import java.awt.geom.Point2D;

public class Winkel1
extends FlatPoleProjection {
    private static final String PROJECTION_NAME = "Winkel I";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double DEFAULT_PHITS = Winkel1.toDegrees(Math.acos(0.6366197723675814));
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.5707963267948966;
    public static final double ASPECT_RATIO = 2.0;
    private double cosPhiTS = Math.cos(DEFAULT_PHITS);

    public Winkel1(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public Winkel1(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public Winkel1(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, Math.PI, 1.5707963267948966, dw, dh, xm, ym);
        this.setExtraParameters(new ProjectionExtraParameter[]{new ProjectionDoubleParameter("Standard Parallel", "\u00b0", DEFAULT_PHITS, 0.0, 90.0, true, false)});
        this.extraParameterChanged();
    }

    public void extraParameterChanged() {
        ProjectionDoubleParameter p = (ProjectionDoubleParameter)this.getParameter(1);
        this.cosPhiTS = Math.cos(Winkel1.toRadians(p.getValue()));
        this.needsUpdate = true;
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return 2.0;
    }

    protected void calculateInverseArray() {
        double y;
        double phiRad;
        this.clearInverseArray();
        for (int iy = 0; iy < this.dstMax.y && !((phiRad = (y = (double)iy + 0.5) * this.oneOverRS) > 1.5707963267948966); ++iy) {
            double x;
            double lambdaRad;
            double phi = Winkel1.toDegrees(phiRad);
            double xFactor = 2.0 * this.oneOverRS / (this.cosPhiTS + Math.cos(phiRad));
            for (int ix = 0; ix < this.dstMax.x && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, Winkel1.toDegrees(lambdaRad), phi);
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = Winkel1.toRadians(lat);
        double x = 0.5 * this.transformLon2LambdaRad(lon) * (this.cosPhiTS + Math.cos(phiRad));
        double y = phiRad;
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

