/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.ConcavePoleProjection;
import java.awt.geom.Point2D;

public class Wagner9
extends ConcavePoleProjection {
    private static final String PROJECTION_NAME = "Wagner IX";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double TERMK = Math.sqrt(2.8);
    private static final double TERMM = 0.7777777777777778;
    private static final double TERMN = 0.2777777777777778;
    private static final double ONE_OVER_M = 1.2857142857142856;
    private static final double ONE_OVER_N = 3.5999999999999996;
    private static final double CSUBX = TERMK / Math.sqrt(0.2160493827160494);
    private static final double CSUBY = 1.0 / (TERMK * Math.sqrt(0.2160493827160494));
    private static final double ONE_OVER_CSUBX2 = 1.0 / (CSUBX * CSUBX);
    private static final double ONE_OVER_CSUBY2 = 1.0 / (CSUBY * CSUBY);
    private static final double WIDTH_FACTOR = CSUBX * 0.2777777777777778 * Math.PI;
    private static final double FOO = Math.cos(1.2217304763960306) * Math.cos(0.8726646259971648);
    private static final double HEIGHT_FACTOR = CSUBY * Math.acos(FOO) * Math.sin(1.2217304763960306) / Math.sqrt(1.0 - FOO * FOO);
    private static final double ASPECT_RATIO = WIDTH_FACTOR / HEIGHT_FACTOR;

    public Wagner9(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public Wagner9(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public Wagner9(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, WIDTH_FACTOR, HEIGHT_FACTOR, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    protected void calculateInverseArray() {
        this.clearInverseArray();
        block0: for (int iy = 0; iy < this.dstMax.y; ++iy) {
            double y = (double)iy + 0.5;
            double y2OverCy2 = y * y * ONE_OVER_CSUBY2;
            double yOverRS = y * this.oneOverRS;
            for (int ix = 0; ix < this.dstMax.x; ++ix) {
                double lambdaRad;
                double phiRad;
                double x = (double)ix + 0.5;
                double d = Math.sqrt(x * x * ONE_OVER_CSUBX2 + y2OverCy2) * this.oneOverRS;
                if (d > 1.0E-5) {
                    double phiTerm = yOverRS * Math.sin(d) / (d * CSUBY);
                    if (phiTerm > 1.0 || (phiRad = Math.asin(phiTerm) * 1.2857142857142856) > 1.5707963267948966) continue;
                    lambdaRad = phiRad < 1.5707963267948966 ? Math.acos(Math.cos(d) / Math.cos(0.7777777777777778 * phiRad)) * 3.5999999999999996 : 0.0;
                    if (lambdaRad > Math.PI) {
                        continue block0;
                    }
                } else {
                    phiRad = 0.0;
                    lambdaRad = 0.0;
                }
                this.setQSymmetricPoints(ix, iy, Wagner9.toDegrees(lambdaRad), Wagner9.toDegrees(phiRad));
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        if (lat == 0.0) {
            double x = this.transformLon2LambdaRad(lon);
            return new Point2D.Double((double)this.dstCenter.x + x * this.rS, this.dstCenter.y);
        }
        double lambdaRad = this.transformLon2LambdaRad(lon);
        double phiRad = Wagner9.toRadians(lat);
        if (lambdaRad == 0.0) {
            double y = phiRad;
            return new Point2D.Double(this.dstCenter.x, (double)this.dstCenter.y - y * this.rS);
        }
        double d = Math.acos(Math.cos(0.7777777777777778 * phiRad) * Math.cos(0.2777777777777778 * lambdaRad));
        double x = 0.0;
        double y = 0.0;
        if (Math.abs(d) > 1.0E-5) {
            double cosA = Math.sin(0.7777777777777778 * phiRad) / Math.sin(d);
            x = CSUBX * d * Math.sqrt(1.0 - cosA * cosA);
            y = CSUBY * d * cosA;
            if (lambdaRad < 0.0) {
                x *= -1.0;
            }
        }
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

