/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.ConcavePoleProjection;
import java.awt.geom.Point2D;

public class Wagner7
extends ConcavePoleProjection {
    private static final String PROJECTION_NAME = "Wagner VII";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double TERMN = 0.3333333333333333;
    private static final double MSUB2 = 1.0;
    private static final double MSUB1 = Math.sin(Wagner7.toRadians(65.0));
    private static final double TERMK = 2.0 * Math.sqrt(Math.sin(Wagner7.toRadians(32.5)));
    private static final double CSUBX = 2.0 * TERMK / Math.sqrt(0.3333333333333333 * MSUB1 * 1.0);
    private static final double CSUBY = 2.0 / (TERMK * Math.sqrt(0.3333333333333333 * MSUB1 * 1.0));
    private static final double HALF_CX = 0.5 * CSUBX;
    private static final double HALF_CY = 0.5 * CSUBY;
    private static final double WIDTH_FACTOR = HALF_CX;
    private static final double STEMP = MSUB1 * Math.sin(1.5707963267948966);
    private static final double C0TEMP = Math.sqrt(1.0 - STEMP * STEMP);
    private static final double C1TEMP = Math.sqrt(2.0 / (1.0 + 0.5 * C0TEMP));
    private static final double HEIGHT_FACTOR = HALF_CY * STEMP * C1TEMP;
    private static final double ASPECT_RATIO = WIDTH_FACTOR / HEIGHT_FACTOR;

    public Wagner7(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public Wagner7(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public Wagner7(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, WIDTH_FACTOR, HEIGHT_FACTOR, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    protected void calculateInverseArray() {
        this.clearInverseArray();
        block0: for (int iy = 0; iy < this.dstMax.y; ++iy) {
            double y = (double)iy + 0.5;
            double yOverCyRS = y * this.oneOverRS / CSUBY;
            double y2OverCy2 = y / CSUBY;
            y2OverCy2 *= y2OverCy2;
            for (int ix = 0; ix < this.dstMax.x; ++ix) {
                double lambdaRad;
                double phiRad;
                double d;
                double x = (double)ix + 0.5;
                double x2OverCx2 = x / CSUBX;
                if ((d = Math.sqrt((x2OverCx2 *= x2OverCx2) + y2OverCy2) * this.oneOverRS) > 1.0E-5) {
                    double delta = 2.0 * Math.asin(d);
                    double s = yOverCyRS * Math.sin(delta) / d;
                    if (s > MSUB1 || (phiRad = Math.asin(s / MSUB1) / 1.0) > 1.5707963267948966) continue;
                    if (phiRad < 1.5707963267948966) {
                        double c0 = Math.sqrt(1.0 - s * s);
                        lambdaRad = 3.0 * Math.acos(Math.cos(delta) / c0);
                    } else {
                        lambdaRad = 0.0;
                    }
                    if (lambdaRad > Math.PI) {
                        continue block0;
                    }
                } else {
                    phiRad = 0.0;
                    lambdaRad = 0.0;
                }
                this.setQSymmetricPoints(ix, iy, Wagner7.toDegrees(lambdaRad), Wagner7.toDegrees(phiRad));
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double lambdaRadOver3 = this.transformLon2LambdaRad(lon) / 3.0;
        double s = MSUB1 * Math.sin(1.0 * Wagner7.toRadians(lat));
        double c0 = Math.sqrt(1.0 - s * s);
        double c1 = Math.sqrt(2.0 / (1.0 + c0 * Math.cos(lambdaRadOver3)));
        double x = HALF_CX * c0 * c1 * Math.sin(lambdaRadOver3);
        double y = HALF_CY * s * c1;
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

