/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.FlatPoleProjection;
import java.awt.geom.Point2D;

public class Wagner6
extends FlatPoleProjection {
    private static final String PROJECTION_NAME = "Wagner VI";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double CSUBX = 1.0;
    private static final double ONE_OVER_CSUBX = 1.0;
    private static final double CSUBY = 1.0;
    private static final double ONE_OVER_CSUBY = 1.0;
    private static final double TERMA = 0.0;
    private static final double TERMB = 3.0;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.5707963267948966;
    private static final double ASPECT_RATIO = 2.0;

    public Wagner6(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public Wagner6(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public Wagner6(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, Math.PI, 1.5707963267948966, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return 2.0;
    }

    protected void calculateInverseArray() {
        double y;
        double phiRad;
        this.clearInverseArray();
        double oneOver2RS = 0.5 * this.oneOverRS;
        for (int iy = 0; iy < this.dstMax.y && !((phiRad = (y = (double)iy + 0.5) * this.oneOverRS * 1.0) > 1.5707963267948966); ++iy) {
            double x;
            double lambdaRad;
            double phi = Wagner6.toDegrees(phiRad);
            double phiOverPi = phiRad * 0.3183098861837907;
            double xFactor = 1.0 * this.oneOverRS / (0.0 + Math.sqrt(1.0 - 3.0 * phiOverPi * phiOverPi));
            for (int ix = 0; ix < this.dstMax.x && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, Wagner6.toDegrees(lambdaRad), phi);
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = Wagner6.toRadians(lat);
        double phiOverPi = phiRad * 0.3183098861837907;
        double x = 1.0 * this.transformLon2LambdaRad(lon) * (0.0 + Math.sqrt(1.0 - 3.0 * phiOverPi * phiOverPi));
        double y = 1.0 * phiRad;
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

