/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.FlatPoleProjection;
import java.awt.geom.Point2D;

public class Wagner5
extends FlatPoleProjection {
    private static final String PROJECTION_NAME = "Wagner V";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double CSUBP = 3.00896;
    private static final double CSUBX = 0.90977;
    private static final double CSUBY = 1.65014;
    private static final double ONE_OVER_CSUBP = 0.332340742316282;
    private static final double ONE_OVER_CSUBX = 1.0991789133517262;
    private static final double ONE_OVER_CSUBY = 0.6060091870992764;
    private static final double WIDTH_FACTOR = 2.858126748456386;
    private static final double HEIGHT_FACTOR = 1.4710338044;
    private static final double ASPECT_RATIO = 1.9429375041603132;

    public Wagner5(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public Wagner5(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public Wagner5(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, 2.858126748456386, 1.4710338044, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return 1.9429375041603132;
    }

    protected void calculateInverseArray() {
        double y;
        double halfThetaRad;
        double thetaRad;
        double phi;
        this.clearInverseArray();
        for (int iy = 0; iy < this.dstMax.y && !((phi = Wagner5.toDegrees(Math.asin(((thetaRad = 2.0 * (halfThetaRad = Math.asin((y = (double)iy + 0.5) * this.oneOverRS * 0.6060091870992764))) + Math.sin(thetaRad)) * 0.332340742316282))) > 90.0); ++iy) {
            double x;
            double lambda;
            double xFactor = this.oneOverRS * 1.0991789133517262 / Math.cos(halfThetaRad);
            for (int ix = 0; ix < this.dstMax.x && !((lambda = Wagner5.toDegrees((x = (double)ix + 0.5) * xFactor)) > 180.0); ++ix) {
                this.setQSymmetricPoints(ix, iy, lambda, phi);
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiFactor = 3.00896 * Math.sin(Wagner5.toRadians(lat));
        double thetaRad = Wagner5.toRadians(lat);
        for (int i = 0; i < 25; ++i) {
            double dthetaRad = (thetaRad + Math.sin(thetaRad) - phiFactor) / (1.0 + Math.cos(thetaRad));
            thetaRad -= dthetaRad;
            if (Math.abs(dthetaRad) < 1.0E-5) break;
        }
        double x = 0.90977 * this.transformLon2LambdaRad(lon) * Math.cos(0.5 * thetaRad);
        double y = 1.65014 * Math.sin(0.5 * thetaRad);
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

