/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.FlatPoleProjection;
import java.awt.geom.Point2D;

public class Wagner4
extends FlatPoleProjection {
    private static final String PROJECTION_NAME = "Wagner IV";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double TERMP = 1.0471975511965976;
    private static final double CSUBP = 2.0943951023931953 + Math.sin(2.0943951023931953);
    private static final double ONE_OVER_CSUBP = 1.0 / CSUBP;
    private static final double TERMR = Math.sqrt(Math.PI * 2 * Math.sin(1.0471975511965976) * ONE_OVER_CSUBP);
    private static final double CSUBX = TERMR * 0.6366197723675814;
    private static final double CSUBY = TERMR / Math.sin(1.0471975511965976);
    private static final double ONE_OVER_CSUBX = 1.0 / CSUBX;
    private static final double ONE_OVER_CSUBY = 1.0 / CSUBY;
    private static final double WIDTH_FACTOR = CSUBX * Math.PI;
    private static final double HEIGHT_FACTOR = CSUBY * Math.sin(1.0471975511965976);
    private static final double ASPECT_RATIO = WIDTH_FACTOR / HEIGHT_FACTOR;

    public Wagner4(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public Wagner4(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public Wagner4(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, WIDTH_FACTOR, HEIGHT_FACTOR, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    protected void calculateInverseArray() {
        double y;
        double halfThetaRad;
        double thetaRad;
        double phi;
        this.clearInverseArray();
        for (int iy = 0; iy < this.dstMax.y && !((phi = Wagner4.toDegrees(Math.asin(((thetaRad = 2.0 * (halfThetaRad = Math.asin((y = (double)iy + 0.5) * this.oneOverRS * ONE_OVER_CSUBY))) + Math.sin(thetaRad)) * ONE_OVER_CSUBP))) > 90.0); ++iy) {
            double x;
            double lambda;
            double xFactor = this.oneOverRS * ONE_OVER_CSUBX / Math.cos(halfThetaRad);
            for (int ix = 0; ix < this.dstMax.x && !((lambda = Wagner4.toDegrees((x = (double)ix + 0.5) * xFactor)) > 180.0); ++ix) {
                this.setQSymmetricPoints(ix, iy, lambda, phi);
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiFactor = CSUBP * Math.sin(Wagner4.toRadians(lat));
        double thetaRad = Wagner4.toRadians(lat);
        for (int i = 0; i < 25; ++i) {
            double dthetaRad = (thetaRad + Math.sin(thetaRad) - phiFactor) / (1.0 + Math.cos(thetaRad));
            thetaRad -= dthetaRad;
            if (Math.abs(dthetaRad) < 1.0E-5) break;
        }
        double x = CSUBX * this.transformLon2LambdaRad(lon) * Math.cos(0.5 * thetaRad);
        double y = CSUBY * Math.sin(0.5 * thetaRad);
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

