/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.FlatPoleProjection;
import gov.nasa.giss.mapping.proj.ProjectionDoubleParameter;
import gov.nasa.giss.mapping.proj.ProjectionExtraParameter;
import java.awt.geom.Point2D;

public class Wagner3
extends FlatPoleProjection {
    private static final String PROJECTION_NAME = "Wagner III";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double DEFAULT_PHITS = 0.0;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.5707963267948966;
    private static final double ASPECT_RATIO = 2.0;
    private double phiTSFactor;

    public Wagner3(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public Wagner3(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public Wagner3(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, Math.PI, 1.5707963267948966, dw, dh, xm, ym);
        this.setExtraParameters(new ProjectionExtraParameter[]{new ProjectionDoubleParameter("Standard Parallel", "\u00b0", 0.0, 0.0, 90.0, true, false)});
        this.extraParameterChanged();
    }

    public void extraParameterChanged() {
        ProjectionDoubleParameter p = (ProjectionDoubleParameter)this.getParameter(1);
        double phiTSRad = Wagner3.toRadians(p.getValue());
        double cosPhiTS = Math.cos(phiTSRad);
        double cos2PhiTSOver3 = Math.cos(phiTSRad * 2.0 / 3.0);
        this.phiTSFactor = cosPhiTS / cos2PhiTSOver3;
        this.needsUpdate = true;
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return 2.0;
    }

    protected void calculateInverseArray() {
        double y;
        double phiRad;
        this.clearInverseArray();
        for (int iy = 0; iy < this.dstMax.y && !((phiRad = (y = (double)iy + 0.5) * this.oneOverRS) > 1.5707963267948966); ++iy) {
            double x;
            double lambdaRad;
            double phi = Wagner3.toDegrees(phiRad);
            double xFactor = this.oneOverRS / (this.phiTSFactor * Math.cos(phiRad * 2.0 / 3.0));
            for (int ix = 0; ix < this.dstMax.x && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, Wagner3.toDegrees(lambdaRad), phi);
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = Wagner3.toRadians(lat);
        double x = this.transformLon2LambdaRad(lon) * this.phiTSFactor * Math.cos(phiRad * 2.0 / 3.0);
        double y = phiRad;
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

