/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.FlatPoleProjection;
import java.awt.geom.Point2D;

public class Wagner2
extends FlatPoleProjection {
    private static final String PROJECTION_NAME = "Wagner II";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double TERMA = 0.92483;
    private static final double TERMB = 1.38725;
    private static final double TERMC = 0.88022;
    private static final double TERMD = 0.8855;
    private static final double ONE_OVER_TERMB = 0.7208506037123805;
    private static final double ONE_OVER_TERMD = 1.129305477131564;
    private static final double WIDTH_FACTOR = 2.9054391338194483;
    private static final double HEIGHT_FACTOR = 1.38725 * Math.asin(0.88022 * Math.sin(1.3909401473768808));
    private static final double ASPECT_RATIO = 2.9054391338194483 / HEIGHT_FACTOR;

    public Wagner2(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public Wagner2(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public Wagner2(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, 2.9054391338194483, HEIGHT_FACTOR, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    protected void calculateInverseArray() {
        double y;
        double thetaRad;
        double phiRad;
        this.clearInverseArray();
        for (int iy = 0; iy < this.dstMax.y && !((phiRad = Math.asin(Math.sin(thetaRad = this.oneOverRS * (y = (double)iy + 0.5) * 0.7208506037123805) / 0.88022) * 1.129305477131564) > 1.5707963267948966); ++iy) {
            double x;
            double lambdaRad;
            double phi = Wagner2.toDegrees(phiRad);
            double xFactor = this.oneOverRS / (0.92483 * Math.cos(thetaRad));
            for (int ix = 0; ix < this.dstMax.x && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, Wagner2.toDegrees(lambdaRad), phi);
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = Wagner2.toRadians(lat);
        double thetaRad = Math.asin(0.88022 * Math.sin(0.8855 * phiRad));
        double x = 0.92483 * this.transformLon2LambdaRad(lon) * Math.cos(thetaRad);
        double y = 1.38725 * thetaRad;
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

