/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.FlatPoleProjection;
import java.awt.geom.Point2D;

public class Wagner1
extends FlatPoleProjection {
    private static final String PROJECTION_NAME = "Wagner I";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double FOURTHROOTOF3 = Math.sqrt(SQRT3);
    private static final double TERMN = 0.5 * SQRT3;
    private static final double CSUBX = 2.0 * FOURTHROOTOF3 / 3.0;
    private static final double CSUBY = 1.0 / CSUBX;
    private static final double CSUBY_OVER_N = CSUBY / TERMN;
    private static final double WIDTH_FACTOR = CSUBX * Math.PI;
    private static final double HEIGHT_FACTOR = CSUBY * Math.asin(TERMN) / TERMN;
    private static final double ASPECT_RATIO = WIDTH_FACTOR / HEIGHT_FACTOR;

    public Wagner1(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public Wagner1(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public Wagner1(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, WIDTH_FACTOR, HEIGHT_FACTOR, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    protected void calculateInverseArray() {
        double y;
        double thetaRad;
        double phiRad;
        this.clearInverseArray();
        for (int iy = 0; iy < this.dstMax.y && !((phiRad = Math.asin(Math.sin(thetaRad = (y = (double)iy + 0.5) * this.oneOverRS / CSUBY_OVER_N) / TERMN)) > 1.5707963267948966); ++iy) {
            double x;
            double lambdaRad;
            double phi = Wagner1.toDegrees(phiRad);
            double xFactor = this.oneOverRS / (CSUBX * Math.cos(thetaRad));
            for (int ix = 0; ix < this.dstMax.x && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, Wagner1.toDegrees(lambdaRad), phi);
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double thetaRad = Math.asin(TERMN * Math.sin(Wagner1.toRadians(lat)));
        double x = CSUBX * this.transformLon2LambdaRad(lon) * Math.cos(thetaRad);
        double y = CSUBY_OVER_N * thetaRad;
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

