/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.AzimuthalProjection;
import gov.nasa.giss.mapping.proj.ProjectionDoubleParameter;
import gov.nasa.giss.mapping.proj.ProjectionExtraParameter;
import java.awt.geom.Point2D;

public class VerticalPerspective
extends AzimuthalProjection {
    private static final String PROJECTION_NAME = "Vertical Perspective";
    private static final boolean IS_AZIMUTHAL = true;
    private static final double WIDTH_FACTOR = 1.0;
    private static final double HEIGHT_FACTOR = 1.0;
    private static final double ASPECT_RATIO = 1.0;
    private double pFactor = 2.5;
    private double oneOverP;

    public VerticalPerspective(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public VerticalPerspective(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public VerticalPerspective(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, true, 1.0, 1.0, dw, dh, xm, ym);
        this.setExtraParameters(new ProjectionExtraParameter[]{new ProjectionDoubleParameter("Center Distance", "R", this.pFactor, 1.0, Double.POSITIVE_INFINITY, false, true)});
        this.extraParameterChanged();
    }

    public void extraParameterChanged() {
        ProjectionDoubleParameter p = (ProjectionDoubleParameter)this.getParameter(1);
        this.pFactor = p.getValue();
        this.fitToTarget();
        this.needsUpdate = true;
    }

    protected void fitToTarget() {
        this.oneOverP = 1.0 / this.pFactor;
        this.heightFactor = this.widthFactor = Math.sqrt((this.pFactor - 1.0) / (this.pFactor + 1.0));
        super.fitToTarget();
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return true;
    }

    public static double getAspectRatio() {
        return 1.0;
    }

    protected void calculateInverseArray() {
        this.clearInverseArray();
        double rhoMax = this.rS * this.heightFactor;
        double rhoMax2 = rhoMax * rhoMax;
        double pSquare = this.pFactor * this.pFactor;
        double pMinus1 = this.pFactor - 1.0;
        if (pMinus1 <= 0.0) {
            return;
        }
        for (int iy = -this.dstMax.y; iy < this.dstMax.y; ++iy) {
            double y = (double)iy + 0.5;
            double y2 = y * y;
            for (int ix = -this.dstMax.x; ix < this.dstMax.x; ++ix) {
                double lambdaRad;
                double phiRad;
                double x = (double)ix + 0.5;
                if (x != 0.0 || y != 0.0) {
                    double rho2 = x * x + y2;
                    if (rho2 > rhoMax2) continue;
                    double rho = Math.sqrt(rho2);
                    double xFactor = rho * this.oneOverRS / pMinus1;
                    double xFactor2 = xFactor * xFactor;
                    double a = xFactor2 + 1.0;
                    double b = -2.0 * this.pFactor * xFactor2;
                    double c = xFactor2 * pSquare - 1.0;
                    double cosZ = (-b + Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a);
                    double sinZ = Math.sqrt(1.0 - cosZ * cosZ);
                    phiRad = Math.asin(cosZ * this.sinLatCOP + y * sinZ * this.cosLatCOP / rho);
                    lambdaRad = Math.atan2(x * sinZ, rho * this.cosLatCOP * cosZ - y * this.sinLatCOP * sinZ);
                } else {
                    phiRad = VerticalPerspective.toRadians(this.cop.y);
                    lambdaRad = 0.0;
                }
                this.setBiSymmetricPoints(ix, iy, VerticalPerspective.toDegrees(lambdaRad), VerticalPerspective.toDegrees(phiRad));
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double lambdaRad = this.transformLon2LambdaRad(lon);
        double cosLambda = Math.cos(lambdaRad);
        double cosLat = Math.cos(VerticalPerspective.toRadians(lat));
        double sinLat = Math.sin(VerticalPerspective.toRadians(lat));
        double cosZ = this.sinLatCOP * sinLat + this.cosLatCOP * cosLat * cosLambda;
        if (cosZ < this.oneOverP) {
            return null;
        }
        double k = (this.pFactor - 1.0) / (this.pFactor - cosZ);
        double x = k * cosLat * Math.sin(lambdaRad);
        double y = k * (this.cosLatCOP * sinLat - this.sinLatCOP * cosLat * cosLambda);
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

