/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.EllipseProjection;
import java.awt.geom.Point2D;

public class VanDerGrinten1
extends EllipseProjection {
    private static final String PROJECTION_NAME = "Van Der Grinten I";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = Math.PI;
    private static final double ASPECT_RATIO = 1.0;

    public VanDerGrinten1(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public VanDerGrinten1(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public VanDerGrinten1(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, Math.PI, Math.PI, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return 1.0;
    }

    protected void calculateInverseArray() {
        this.clearInverseArray();
        double rhoMax = this.rS * this.heightFactor;
        double rhoMax2 = rhoMax * rhoMax;
        double oneOverPiRS = this.oneOverRS * 0.3183098861837907;
        for (int iy = 0; iy < this.dstMax.y; ++iy) {
            double y = (double)iy + 0.5;
            double y2 = y * y;
            double capY = y * this.oneOverRS * 0.3183098861837907;
            double capY2 = capY * capY;
            for (int ix = 0; ix < this.dstMax.x; ++ix) {
                double x = (double)ix + 0.5;
                double x2 = x * x;
                if (y2 + x * x > rhoMax2) continue;
                double capX = x * oneOverPiRS;
                double capX2 = capX * capX;
                double capX2pY2 = capX2 + capY2;
                double c1 = -Math.abs(capY) * (1.0 + capX2pY2);
                double c2 = c1 - 2.0 * capY2 + capX2;
                double c3 = -2.0 * c1 + 1.0 + 2.0 * capY2 + capX2pY2 * capX2pY2;
                double d = capY2 / c3 + (2.0 * c2 * c2 * c2 / c3 - 9.0 * c1 * c2) / (27.0 * c3 * c3);
                double a1 = (c1 - c2 * c2 / (3.0 * c3)) / c3;
                double m1 = 2.0 * Math.sqrt(-a1 / 3.0);
                double theta1 = Math.acos(3.0 * d / (a1 * m1)) / 3.0;
                double phiRad = Math.PI * (-m1 * Math.cos(theta1 + 1.0471975511965976) - c2 / (3.0 * c3));
                double lambdaRad = capX == 0.0 ? 0.0 : 1.5707963267948966 * (capX2pY2 - 1.0 + Math.sqrt(1.0 + 2.0 * (capX2 - capY2) + capX2pY2 * capX2pY2)) / capX;
                if (lambdaRad > Math.PI) continue;
                this.setQSymmetricPoints(ix, iy, VanDerGrinten1.toDegrees(lambdaRad), VanDerGrinten1.toDegrees(phiRad));
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double lambdaRad = this.transformLon2LambdaRad(lon);
        if (lat == 0.0) {
            double x = lambdaRad;
            double y = 0.0;
            return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
        }
        if (lat == 90.0 || lat == -90.0) {
            double x = 0.0;
            double y = Math.PI;
            if (lat < 0.0) {
                y = -y;
            }
            return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
        }
        double b = Math.abs(VanDerGrinten1.toRadians(lat) / 1.5707963267948966);
        double c = Math.sqrt(1.0 - b * b);
        if (lambdaRad == 0.0) {
            double x = 0.0;
            double y = Math.PI * b / (1.0 + c);
            if (lat < 0.0) {
                y = -y;
            }
            return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
        }
        double a = 0.5 * Math.abs(Math.PI / lambdaRad - lambdaRad / Math.PI);
        double a2 = a * a;
        double g = c / (b + c - 1.0);
        double p = g * (2.0 / b - 1.0);
        double p2 = p * p;
        double q = a2 + g;
        double s = p2 + a2;
        double t = g - p2;
        double x = Math.PI * (a * t + Math.sqrt(a2 * t * t - s * (g * g - p2))) / s;
        double y = Math.PI * (p * q - a * Math.sqrt((a2 + 1.0) * s - q * q)) / s;
        if (lambdaRad < 0.0) {
            x = -x;
        }
        if (lat < 0.0) {
            y = -y;
        }
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

