/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.AzimuthalProjection;
import java.awt.geom.Point2D;

public class Stereographic
extends AzimuthalProjection {
    private static final String PROJECTION_NAME = "Stereographic";
    private static final boolean IS_AZIMUTHAL = true;
    private static final double WIDTH_FACTOR = 2.0;
    private static final double HEIGHT_FACTOR = 2.0;
    private static final double ASPECT_RATIO = 1.0;

    public Stereographic(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public Stereographic(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public Stereographic(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, true, 2.0, 2.0, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return true;
    }

    public static double getAspectRatio() {
        return 1.0;
    }

    protected void calculateInverseArray() {
        this.clearInverseArray();
        double rhoMax = this.rS * this.heightFactor;
        double rhoMax2 = rhoMax * rhoMax;
        double oneOver2RS = 0.5 * this.oneOverRS;
        for (int iy = -this.dstMax.y; iy < this.dstMax.y; ++iy) {
            double y = (double)iy + 0.5;
            double y2 = y * y;
            for (int ix = 0; ix < this.dstMax.x; ++ix) {
                double lambdaRad;
                double phiRad;
                double x = (double)ix + 0.5;
                if (x != 0.0 || y != 0.0) {
                    double rho2 = x * x + y2;
                    if (rho2 > rhoMax2) continue;
                    double rho = Math.sqrt(rho2);
                    double z = 2.0 * Math.atan(rho * oneOver2RS);
                    double sinZ = Math.sin(z);
                    double cosZ = Math.cos(z);
                    phiRad = Math.asin(cosZ * this.sinLatCOP + y * sinZ * this.cosLatCOP / rho);
                    lambdaRad = Math.atan2(x * sinZ, rho * this.cosLatCOP * cosZ - y * this.sinLatCOP * sinZ);
                } else {
                    phiRad = Stereographic.toRadians(this.cop.y);
                    lambdaRad = 0.0;
                }
                this.setBiSymmetricPoints(ix, iy, Stereographic.toDegrees(lambdaRad), Stereographic.toDegrees(phiRad));
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double lambdaRad = this.transformLon2LambdaRad(lon);
        double cosLambda = Math.cos(lambdaRad);
        double cosLat = Math.cos(Stereographic.toRadians(lat));
        double sinLat = Math.sin(Stereographic.toRadians(lat));
        double k = 2.0 / (1.0 + this.sinLatCOP * sinLat + this.cosLatCOP * cosLat * cosLambda);
        if (k > 2.0) {
            return null;
        }
        double x = k * cosLat * Math.sin(lambdaRad);
        double y = k * (this.cosLatCOP * sinLat - this.sinLatCOP * cosLat * cosLambda);
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

