/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.PointPoleProjection;
import java.awt.geom.Point2D;

public class Sinusoidal
extends PointPoleProjection {
    private static final String PROJECTION_NAME = "Sinusoidal";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.5707963267948966;
    private static final double ASPECT_RATIO = 2.0;

    public Sinusoidal(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public Sinusoidal(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public Sinusoidal(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, Math.PI, 1.5707963267948966, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return 2.0;
    }

    protected void calculateInverseArray() {
        double y;
        double phiRad;
        this.clearInverseArray();
        for (int iy = 0; iy < this.dstMax.y && !((phiRad = (y = (double)iy + 0.5) * this.oneOverRS) > 1.5707963267948966); ++iy) {
            double x;
            double lambdaRad;
            double phi = Sinusoidal.toDegrees(phiRad);
            double xFactor = this.oneOverRS / Math.cos(phiRad);
            for (int ix = 0; ix < this.dstMax.x && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, Sinusoidal.toDegrees(lambdaRad), phi);
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = Sinusoidal.toRadians(lat);
        double x = this.transformLon2LambdaRad(lon) * Math.cos(phiRad);
        double y = phiRad;
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

