/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.QuadSymmetricProjection;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public abstract class RectangleProjection
extends QuadSymmetricProjection {
    public void drawBorder(Graphics2D g2d) {
        if (this.borderStroke == null || this.foreground == null) {
            return;
        }
        g2d.setColor(this.foreground);
        if (this.borderStroke.getLineJoin() != 0 || this.borderStroke.getEndCap() != 2) {
            g2d.setStroke(new BasicStroke(this.borderStroke.getLineWidth(), 2, 0));
        } else {
            g2d.setStroke(this.borderStroke);
        }
        GeneralPath path = new GeneralPath();
        path.moveTo(this.dstCenter.x - this.dstMax.x, this.dstCenter.y - this.dstMax.y);
        path.lineTo(this.dstCenter.x - this.dstMax.x, this.dstCenter.y + this.dstMax.y);
        path.lineTo(this.dstCenter.x + this.dstMax.x, this.dstCenter.y + this.dstMax.y);
        path.lineTo(this.dstCenter.x + this.dstMax.x, this.dstCenter.y - this.dstMax.y);
        path.closePath();
        g2d.draw(path);
    }

    public void drawGrid(Graphics2D g2d, BasicStroke stroke, Color color) {
        Point2D.Double dot;
        if (color == null || stroke == null) {
            return;
        }
        GeneralPath path = new GeneralPath();
        for (int j = -90 + this.gridSpacing; j < 90; j += this.gridSpacing) {
            dot = this.transformLL2XY(0.0, j);
            if (dot == null) continue;
            path.moveTo(this.dstCenter.x - this.dstMax.x, (float)dot.y);
            path.lineTo(this.dstCenter.x + this.dstMax.x, (float)dot.y);
        }
        for (int i = 0; i < 360; i += this.gridSpacing) {
            dot = this.transformLL2XY(i, 0.0);
            if (dot == null) continue;
            path.moveTo((float)dot.x, this.dstCenter.y + this.dstMax.y);
            path.lineTo((float)dot.x, this.dstCenter.y - this.dstMax.y);
        }
        g2d.setColor(color);
        g2d.setStroke(stroke);
        g2d.draw(path);
    }
}

