/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.mapping.proj.BiSymmetricProjection;
import gov.nasa.giss.mapping.proj.ProjectionDoubleParameter;
import gov.nasa.giss.mapping.proj.ProjectionExtraParameter;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Vector;

public class RaiszArmadillo
extends BiSymmetricProjection {
    private static final String PROJECTION_NAME = "Raisz Armadillo";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double DEFAULT_TILT = 20.0;
    private static final double MAX_TILT = 90.0;
    private static final double WIDTH_FACTOR = 2.0;
    private static final double HEIGHT_FACTOR = 0.5 * (1.0 + Math.sin(RaiszArmadillo.toRadians(45.0)) + Math.cos(RaiszArmadillo.toRadians(45.0)));
    public static final double ASPECT_RATIO = 2.0 / HEIGHT_FACTOR;
    private double tilt;
    private double cosTilt;
    private double sinTilt;
    private double tanTilt;
    private double yShift;
    private Bezier[] curves = new Bezier[5];

    public RaiszArmadillo(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public RaiszArmadillo(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public RaiszArmadillo(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, 2.0, HEIGHT_FACTOR, dw, dh, xm, ym);
        this.setExtraParameters(new ProjectionExtraParameter[]{new ProjectionDoubleParameter("Tilt Angle", "\u00b0", 20.0, -90.0, 90.0)});
        this.extraParameterChanged();
    }

    public void extraParameterChanged() {
        ProjectionDoubleParameter p = (ProjectionDoubleParameter)this.getParameter(1);
        this.tilt = p.getValue();
        double tiltRad = RaiszArmadillo.toRadians(this.tilt);
        this.cosTilt = Math.cos(tiltRad);
        this.sinTilt = Math.sin(tiltRad);
        this.tanTilt = Math.tan(tiltRad);
        this.yShift = this.tilt > 0.0 ? 0.5 * (1.0 + this.sinTilt - this.cosTilt) : -0.5 * (1.0 - this.sinTilt - this.cosTilt);
        for (int i = 0; i < 5; ++i) {
            this.curves[i] = null;
        }
        this.needsUpdate = true;
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    public void drawBorder(Graphics2D g2d) {
        if (this.borderStroke == null || this.foreground == null) {
            return;
        }
        g2d.setStroke(this.borderStroke);
        g2d.setColor(this.foreground);
        this.makeBezier();
        for (int i = 0; i < this.curves.length; ++i) {
            if (this.curves[i] == null) continue;
            this.curves[i].paint(g2d);
        }
        if (this.tilt == 0.0) {
            Point2D.Double dot = this.transformLL2XY(this.cop.x + 180.0 - 0.05, 90.0);
            g2d.draw(new Line2D.Double(dot.x, dot.y, 2.0 * (double)this.dstCenter.x - dot.x, dot.y));
            g2d.draw(new Line2D.Double(dot.x, 2.0 * (double)this.dstCenter.y - dot.y, 2.0 * (double)this.dstCenter.x - dot.x, 2.0 * (double)this.dstCenter.y - dot.y));
        }
    }

    private void makeBezier() {
        if (this.tilt == 0.0) {
            this.makeBezier0();
            return;
        }
        Vector<Point2D.Double> vector1 = new Vector<Point2D.Double>(100);
        Vector<Point2D.Double> vector2 = new Vector<Point2D.Double>(100);
        Vector<Point2D.Double> vector3 = new Vector<Point2D.Double>(100);
        Vector<Point2D.Double> vector4 = new Vector<Point2D.Double>(100);
        int np = 60;
        double npfact = 3.0;
        double edgeLon = this.cop.x + 180.0;
        Point2D.Double lastDot = null;
        for (int j = 0; j < 60; ++j) {
            Point2D.Double dot;
            double lat = 90.0 - 3.0 * (double)j;
            if (this.tilt < 0.0) {
                lat *= -1.0;
            }
            if ((dot = this.transformLL2XY(edgeLon - 0.1, lat)) == null) break;
            vector1.add(new Point2D.Double(dot.x, dot.y));
            vector2.add(new Point2D.Double(2.0 * (double)this.dstCenter.x - dot.x, dot.y));
            lastDot = dot;
        }
        if (lastDot != null) {
            vector3.add(new Point2D.Double(lastDot.x, lastDot.y));
            vector4.add(new Point2D.Double(2.0 * (double)this.dstCenter.x - lastDot.x, lastDot.y));
        }
        double subtract = 0.0;
        while (subtract < 180.0) {
            subtract = subtract < 5.0 ? (subtract += 0.5) : (subtract < 30.0 ? (subtract += 1.0) : (subtract < 60.0 ? (subtract += 2.0) : (subtract += 3.0)));
            double dlon = Math.max(180.0 - subtract, 0.0);
            double latLimit = this.findLatLimit(dlon) + (this.tilt > 0.0 ? 0.01 : -0.01);
            Point2D.Double dot = this.transformLL2XY(this.cop.x + dlon - 0.01, latLimit);
            if (dot == null || dot.x > lastDot.x) continue;
            vector3.add(new Point2D.Double(dot.x, dot.y));
            vector4.add(new Point2D.Double(2.0 * (double)this.dstCenter.x - dot.x, dot.y));
        }
        int ew = 60;
        double ewfact = 3.0;
        double plat = this.tilt > 0.0 ? 89.9 : -89.9;
        Point2D.Double[] dots5 = new Point2D.Double[121];
        for (int i = 0; i <= 60; ++i) {
            double dlon = 3.0 * (double)i;
            if (i == 60) {
                dlon -= 0.1;
            }
            Point2D.Double dot = this.transformLL2XY(this.cop.x + dlon, plat);
            dots5[60 - i] = new Point2D.Double(dot.x, dot.y);
            dots5[60 + i] = new Point2D.Double(2.0 * (double)this.dstCenter.x - dot.x, dot.y);
        }
        this.curves[0] = new Bezier(false, vector1);
        this.curves[1] = new Bezier(false, vector2);
        this.curves[2] = new Bezier(false, vector3);
        this.curves[3] = new Bezier(false, vector4);
        this.curves[4] = new Bezier(false, dots5);
    }

    protected void makeBezier0() {
        double edgeLon = this.cop.x + 180.0 - 0.05;
        int np = 30;
        double fact = 3.0;
        Point2D.Double[] dotsE = new Point2D.Double[61];
        Point2D.Double[] dotsW = new Point2D.Double[61];
        for (int j = 0; j <= 30; ++j) {
            double jj = 3.0 * (double)j;
            Point2D.Double dot = this.transformLL2XY(edgeLon, jj);
            dotsE[30 - j] = new Point2D.Double(dot.x, dot.y);
            dotsE[30 + j] = new Point2D.Double(dot.x, 2.0 * (double)this.dstCenter.y - dot.y);
            dotsW[30 - j] = new Point2D.Double(2.0 * (double)this.dstCenter.x - dot.x, dot.y);
            dotsW[30 + j] = new Point2D.Double(2.0 * (double)this.dstCenter.x - dot.x, 2.0 * (double)this.dstCenter.y - dot.y);
        }
        this.curves[0] = new Bezier(false, dotsE);
        this.curves[1] = new Bezier(false, dotsW);
    }

    protected void calculateInverseArray() {
        this.clearInverseArray();
        double yfullMin = this.tilt > 0.0 ? this.transformLL2XY((double)this.cop.x, (double)(-90.0 + this.tilt + 0.1)).y : this.transformLL2XY((double)this.cop.x, (double)-90.0).y;
        double yfullMax = this.tilt < 0.0 ? this.transformLL2XY((double)this.cop.x, (double)(90.0 + this.tilt - 0.1)).y : this.transformLL2XY((double)this.cop.x, (double)90.0).y;
        double yhornMin = this.tilt > 0.0 ? yfullMax : this.transformLL2XY((double)(this.cop.x + 180.0), (double)-90.0).y;
        double yhornMax = this.tilt < 0.0 ? yfullMin : this.transformLL2XY((double)(this.cop.x + 180.0), (double)90.0).y;
        yfullMin = -(yfullMin - (double)this.dstCenter.y);
        yfullMax = -(yfullMax - (double)this.dstCenter.y);
        yhornMin = -(yhornMin - (double)this.dstCenter.y);
        yhornMax = -(yhornMax - (double)this.dstCenter.y);
        int xMin = 0;
        block0: for (int iy = -this.dstMax.y; iy < this.dstMax.y; ++iy) {
            double phiRad;
            double lambdaRad;
            double y = (double)iy + 0.5;
            if (y >= yfullMin && y <= yfullMax) {
                lambdaRad = 1.0E-5;
                phiRad = RaiszArmadillo.toRadians(this.tilt);
                xMin = 0;
            } else {
                if (!(y > yhornMin) || !(y < yhornMax)) continue;
                if (this.tilt > 0.0) {
                    lambdaRad = 2.0 * Math.acos((this.yShift + this.cosTilt - y * this.oneOverRS) / this.sinTilt);
                    phiRad = RaiszArmadillo.toRadians(89.0);
                } else if (this.tilt < 0.0) {
                    lambdaRad = 2.0 * Math.acos((this.yShift - this.cosTilt - y * this.oneOverRS) / this.sinTilt);
                    phiRad = RaiszArmadillo.toRadians(-89.0);
                } else {
                    lambdaRad = 0.0;
                    phiRad = 0.0;
                }
                xMin = (int)(0.5 + this.rS * Math.sin(0.5 * lambdaRad));
            }
            for (int ix = xMin; ix < this.dstMax.x; ++ix) {
                double x = (double)ix + 0.5;
                if (ix > xMin) {
                    phiRad += 1.0E-5;
                    lambdaRad += 1.0E-5;
                }
                int iters = 0;
                for (int iter = 0; iter < 25; ++iter) {
                    double halfLambdaRad = 0.5 * lambdaRad;
                    double cosHalfLambda = Math.cos(halfLambdaRad);
                    double sinHalfLambda = Math.sin(halfLambdaRad);
                    double cosPhi = Math.cos(phiRad);
                    double sinPhi = Math.sin(phiRad);
                    double onePlusCosPhi = 1.0 + Math.cos(phiRad);
                    double df1dPhi = -sinHalfLambda * sinPhi;
                    double df1dLambda = 0.5 * onePlusCosPhi * cosHalfLambda;
                    double df2dPhi = this.cosTilt * cosPhi + this.sinTilt * cosHalfLambda * sinPhi;
                    double df2dLambda = 0.5 * this.sinTilt * onePlusCosPhi * sinHalfLambda;
                    double f1 = onePlusCosPhi * sinHalfLambda - x * this.oneOverRS;
                    double f2 = this.yShift + this.cosTilt * sinPhi - this.sinTilt * onePlusCosPhi * cosHalfLambda - y * this.oneOverRS;
                    double denom = df1dPhi * df2dLambda - df2dPhi * df1dLambda;
                    double dphiX = (f1 * df2dLambda - f2 * df1dLambda) / denom;
                    double lambdaX = (f2 * df1dPhi - f1 * df2dPhi) / denom;
                    phiRad -= dphiX;
                    lambdaRad -= lambdaX;
                    if (Math.abs(dphiX) < 1.0E-5 && Math.abs(lambdaX) < 1.0E-5) break;
                    ++iters;
                }
                if (iters > 24 || lambdaRad > Math.PI) continue block0;
                double lambda = RaiszArmadillo.toDegrees(lambdaRad);
                double phi = RaiszArmadillo.toDegrees(phiRad);
                double phiLim = this.findLatLimit(lambda);
                if (this.tilt > 0.0 && phi < phiLim || this.tilt < 0.0 && phi > phiLim) continue block0;
                this.setBiSymmetricPoints(ix, iy, lambda, phi);
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double lambda = this.transformLon2Lambda(lon);
        double latLimit = this.findLatLimit(lambda);
        if (this.tilt > 0.0 && lat < latLimit || this.tilt < 0.0 && lat > latLimit) {
            return null;
        }
        double phiRad = RaiszArmadillo.toRadians(lat);
        double cosPhi = Math.cos(phiRad);
        double sinPhi = Math.sin(phiRad);
        double onePlusCosPhi = 1.0 + Math.cos(phiRad);
        double halfLambdaRad = 0.5 * RaiszArmadillo.toRadians(lambda);
        double x = onePlusCosPhi * Math.sin(halfLambdaRad);
        double y = this.yShift + this.cosTilt * sinPhi - this.sinTilt * onePlusCosPhi * Math.cos(halfLambdaRad);
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }

    private double findLatLimit(double lambda) {
        double limit = -RaiszArmadillo.toDegrees(Math.atan2(Math.cos(RaiszArmadillo.toRadians(0.5 * lambda)), Math.abs(this.tanTilt)));
        if (this.tilt < 0.0) {
            limit = Math.abs(limit);
        }
        return limit;
    }
}

