/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.PointPoleProjection;
import java.awt.geom.Point2D;

public class QuarticAuthalic
extends PointPoleProjection {
    private static final String PROJECTION_NAME = "Quartic Authalic";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double TERM_Q = 2.0;
    private static final double TERM_P = 2.0;
    private static final double Q_OVER_P = 1.0;
    private static final double P_OVER_Q = 1.0;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 2.0 * Math.sin(0.7853981633974483);
    private static final double ASPECT_RATIO = Math.PI / HEIGHT_FACTOR;

    public QuarticAuthalic(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public QuarticAuthalic(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public QuarticAuthalic(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, Math.PI, HEIGHT_FACTOR, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    protected void calculateInverseArray() {
        double y;
        double phiRad;
        double phi;
        this.clearInverseArray();
        double oneOverPRS = this.oneOverRS / 2.0;
        for (int iy = 0; iy < this.dstMax.y && !((phi = QuarticAuthalic.toDegrees(phiRad = 2.0 * Math.asin((y = (double)iy + 0.5) * oneOverPRS))) > 90.0); ++iy) {
            double x;
            double lambda;
            double xFactor = this.oneOverRS * 1.0 * Math.cos(phiRad / 2.0) / Math.cos(phiRad);
            for (int ix = 0; ix < this.dstMax.x && !((lambda = QuarticAuthalic.toDegrees((x = (double)ix + 0.5) * xFactor)) > 180.0); ++ix) {
                this.setQSymmetricPoints(ix, iy, lambda, phi);
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = QuarticAuthalic.toRadians(lat);
        double phiOverQ = phiRad / 2.0;
        double x = 1.0 * this.transformLon2LambdaRad(lon) * Math.cos(phiRad) / Math.cos(phiOverQ);
        double y = 2.0 * Math.sin(phiOverQ);
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

