/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.AbstractProjection;

public abstract class QuadSymmetricProjection
extends AbstractProjection {
    protected void setQSymmetricPoints(int ix, int iy, double lambda, double phi) {
        int col = this.dstCenter.x + ix;
        int colF = this.dstCenter.x - 1 - ix;
        int row = this.dstCenter.y - 1 - iy;
        int rowF = this.dstCenter.y + iy;
        if (row < 0 || row >= this.dstSize.height || rowF < 0 || rowF >= this.dstSize.height || col < 0 || col >= this.dstSize.width || colF < 0 || colF >= this.dstSize.width) {
            return;
        }
        int srcY = this.getSrcPixelY(phi);
        int srcYF = this.getSrcPixelY(-phi);
        int srcX = this.getSrcPixelX(this.cop.x + lambda);
        int srcXF = this.getSrcPixelX(this.cop.x - lambda);
        int indexTR = row * this.dstSize.width + col;
        int indexTL = row * this.dstSize.width + colF;
        int indexBR = rowF * this.dstSize.width + col;
        int indexBL = rowF * this.dstSize.width + colF;
        this.invArray[indexTR] = srcY * this.srcSize.width + srcX;
        this.invArray[indexTL] = srcY * this.srcSize.width + srcXF;
        this.invArray[indexBR] = srcYF * this.srcSize.width + srcX;
        this.invArray[indexBL] = srcYF * this.srcSize.width + srcXF;
        this.invArrayLon[indexTR] = this.cop.x + lambda;
        this.invArrayLon[indexTL] = this.cop.x - lambda;
        this.invArrayLon[indexBR] = this.cop.x + lambda;
        this.invArrayLon[indexBL] = this.cop.x - lambda;
        this.invArrayLat[indexTR] = phi;
        this.invArrayLat[indexTL] = phi;
        this.invArrayLat[indexBR] = -phi;
        this.invArrayLat[indexBL] = -phi;
    }
}

