/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.FlatPoleProjection;
import java.awt.geom.Point2D;

public class PutninsP5p
extends FlatPoleProjection {
    private static final String PROJECTION_NAME = "Putni\u0146\u0161 P5'";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double TERMX = 1.01346;
    private static final double TERMA = 1.5;
    private static final double TERMB = 0.5;
    private static final double ONE_OVER_X = 0.9867187654174807;
    private static final double TWELVE_OVER_PI2 = 1.2158542037080533;
    private static final double WIDTH_FACTOR = 3.183878490707112;
    private static final double HEIGHT_FACTOR = 1.591939245353556;
    private static final double ASPECT_RATIO = 2.0;

    public PutninsP5p(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public PutninsP5p(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public PutninsP5p(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, 3.183878490707112, 1.591939245353556, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return 2.0;
    }

    protected void calculateInverseArray() {
        double y;
        double phiRad;
        double phi;
        this.clearInverseArray();
        for (int iy = 0; iy < this.dstMax.y && !((phi = PutninsP5p.toDegrees(phiRad = (y = (double)iy + 0.5) * this.oneOverRS * 0.9867187654174807)) > 90.0); ++iy) {
            double x;
            double lambda;
            double xFactor = 0.9867187654174807 * this.oneOverRS / (1.5 - 0.5 * Math.sqrt(1.0 + 1.2158542037080533 * phiRad * phiRad));
            for (int ix = 0; ix < this.dstMax.x && !((lambda = PutninsP5p.toDegrees((x = (double)ix + 0.5) * xFactor)) > 180.0); ++ix) {
                this.setQSymmetricPoints(ix, iy, lambda, phi);
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = PutninsP5p.toRadians(lat);
        double x = 1.01346 * this.transformLon2LambdaRad(lon) * (1.5 - 0.5 * Math.sqrt(1.0 + 1.2158542037080533 * phiRad * phiRad));
        double y = 1.01346 * phiRad;
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

