/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.FlatPoleProjection;
import java.awt.geom.Point2D;

public class PutninsP4p
extends FlatPoleProjection {
    private static final String PROJECTION_NAME = "Putni\u0146\u0161 P4'";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double TERMX = 5.0 * SQRT2 / 8.0;
    private static final double CSUBX = 2.0 * Math.sqrt(0.1909859317102744);
    private static final double CSUBY = 2.0 * Math.sqrt(3.7699111843077517);
    private static final double WIDTH_FACTOR = CSUBX * Math.PI;
    private static final double HEIGHT_FACTOR = CSUBY * Math.sin(Math.asin(TERMX) / 3.0);
    private static final double ASPECT_RATIO = WIDTH_FACTOR / HEIGHT_FACTOR;

    public PutninsP4p(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public PutninsP4p(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public PutninsP4p(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, WIDTH_FACTOR, HEIGHT_FACTOR, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    protected void calculateInverseArray() {
        double y;
        double thetaRad;
        double phiRad;
        double phi;
        this.clearInverseArray();
        for (int iy = 0; iy < this.dstMax.y && !((phi = PutninsP4p.toDegrees(phiRad = Math.asin(Math.sin(thetaRad = 3.0 * Math.asin(this.oneOverRS * (y = (double)iy + 0.5) / CSUBY)) / TERMX))) > 90.0); ++iy) {
            double x;
            double lambda;
            double xFactor = this.oneOverRS / CSUBX * (Math.cos(thetaRad / 3.0) / Math.cos(thetaRad));
            for (int ix = 0; ix < this.dstMax.x && !((lambda = PutninsP4p.toDegrees((x = (double)ix + 0.5) * xFactor)) > 180.0); ++ix) {
                this.setQSymmetricPoints(ix, iy, lambda, phi);
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = PutninsP4p.toRadians(lat);
        double thetaRad = Math.asin(TERMX * Math.sin(phiRad));
        double x = CSUBX * this.transformLon2LambdaRad(lon) * Math.cos(thetaRad) / Math.cos(thetaRad / 3.0);
        double y = CSUBY * Math.sin(thetaRad / 3.0);
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

