/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.FlatPoleProjection;
import java.awt.geom.Point2D;

public class PutninsP3p
extends FlatPoleProjection {
    private static final String PROJECTION_NAME = "Putni\u0146\u0161 P3'";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double TERMA = Math.sqrt(0.6366197723675814);
    private static final double ONE_OVER_TERMA = 1.0 / TERMA;
    private static final double TERMB = 2.0;
    private static final double TERMB_OVER_PI2 = 0.20264236728467555;
    private static final double WIDTH_FACTOR = TERMA * Math.PI;
    private static final double HEIGHT_FACTOR = ONE_OVER_TERMA;
    private static final double ASPECT_RATIO = WIDTH_FACTOR / HEIGHT_FACTOR;

    public PutninsP3p(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public PutninsP3p(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public PutninsP3p(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, WIDTH_FACTOR, HEIGHT_FACTOR, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    protected void calculateInverseArray() {
        double y;
        double phiRad;
        this.clearInverseArray();
        for (int iy = 0; iy < this.dstMax.y && !((phiRad = (y = (double)iy + 0.5) * this.oneOverRS * ONE_OVER_TERMA) > 1.5707963267948966); ++iy) {
            double x;
            double lambdaRad;
            double xFactor = ONE_OVER_TERMA * this.oneOverRS / (1.0 - phiRad * phiRad * 0.20264236728467555);
            for (int ix = 0; ix < this.dstMax.x && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                this.setQSymmetricPoints(ix, iy, PutninsP3p.toDegrees(lambdaRad), PutninsP3p.toDegrees(phiRad));
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = PutninsP3p.toRadians(lat);
        double x = TERMA * this.transformLon2LambdaRad(lon) * (1.0 - phiRad * phiRad * 0.20264236728467555);
        double y = TERMA * phiRad;
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

