/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.PointPoleProjection;
import java.awt.geom.Point2D;

public class PutninsP1
extends PointPoleProjection {
    private static final String PROJECTION_NAME = "Putni\u0146\u0161 P1";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double CSUBX = 1.8949;
    private static final double ONE_OVER_CSUBX = 0.527732334160114;
    private static final double CSUBY = 0.94745;
    private static final double ONE_OVER_CSUBY = 1.055464668320228;
    private static final double TERMA = -0.5;
    private static final double TERMB = 3.0;
    private static final double WIDTH_FACTOR = 2.9765019596436497;
    private static final double HEIGHT_FACTOR = 1.4882509798218249;
    private static final double ASPECT_RATIO = 2.0;

    public PutninsP1(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public PutninsP1(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public PutninsP1(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, 2.9765019596436497, 1.4882509798218249, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return 2.0;
    }

    protected void calculateInverseArray() {
        double y;
        double phiRad;
        this.clearInverseArray();
        double oneOver2RS = 0.5 * this.oneOverRS;
        for (int iy = 0; iy < this.dstMax.y && !((phiRad = (y = (double)iy + 0.5) * this.oneOverRS * 1.055464668320228) > 1.5707963267948966); ++iy) {
            double x;
            double lambda;
            double phiOverPi = phiRad * 0.3183098861837907;
            double xFactor = 0.527732334160114 * this.oneOverRS / (-0.5 + Math.sqrt(1.0 - 3.0 * phiOverPi * phiOverPi));
            for (int ix = 0; ix < this.dstMax.x && !((lambda = PutninsP1.toDegrees((x = (double)ix + 0.5) * xFactor)) > 180.0); ++ix) {
                this.setQSymmetricPoints(ix, iy, lambda, PutninsP1.toDegrees(phiRad));
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = PutninsP1.toRadians(lat);
        double phiOverPi = phiRad * 0.3183098861837907;
        double x = 1.8949 * this.transformLon2LambdaRad(lon) * (-0.5 + Math.sqrt(1.0 - 3.0 * phiOverPi * phiOverPi));
        double y = 0.94745 * phiRad;
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

