/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.AbstractProjection;
import gov.nasa.giss.mapping.proj.Aitoff;
import gov.nasa.giss.mapping.proj.ApianGlobular2;
import gov.nasa.giss.mapping.proj.AzimEqualarea;
import gov.nasa.giss.mapping.proj.AzimEquidistant;
import gov.nasa.giss.mapping.proj.Denoyer;
import gov.nasa.giss.mapping.proj.Eckert3;
import gov.nasa.giss.mapping.proj.Eckert4;
import gov.nasa.giss.mapping.proj.Eckert5;
import gov.nasa.giss.mapping.proj.Eckert6;
import gov.nasa.giss.mapping.proj.EckertGreifendorff;
import gov.nasa.giss.mapping.proj.Equirectangular;
import gov.nasa.giss.mapping.proj.FlatPolarParabolic;
import gov.nasa.giss.mapping.proj.FlatPolarQuartic;
import gov.nasa.giss.mapping.proj.FlatPolarSinusoidal;
import gov.nasa.giss.mapping.proj.Gall;
import gov.nasa.giss.mapping.proj.Hammer;
import gov.nasa.giss.mapping.proj.Holzel;
import gov.nasa.giss.mapping.proj.Kavraisky5;
import gov.nasa.giss.mapping.proj.Kavraisky7;
import gov.nasa.giss.mapping.proj.McBrydeThomasSine1;
import gov.nasa.giss.mapping.proj.Mercator;
import gov.nasa.giss.mapping.proj.MillerCylindrical;
import gov.nasa.giss.mapping.proj.Mollweide;
import gov.nasa.giss.mapping.proj.NellHammer;
import gov.nasa.giss.mapping.proj.OrteliusOval;
import gov.nasa.giss.mapping.proj.Orthographic;
import gov.nasa.giss.mapping.proj.Parabolic;
import gov.nasa.giss.mapping.proj.PutninsP1;
import gov.nasa.giss.mapping.proj.PutninsP1p;
import gov.nasa.giss.mapping.proj.PutninsP3;
import gov.nasa.giss.mapping.proj.PutninsP3p;
import gov.nasa.giss.mapping.proj.PutninsP4p;
import gov.nasa.giss.mapping.proj.PutninsP5;
import gov.nasa.giss.mapping.proj.PutninsP5p;
import gov.nasa.giss.mapping.proj.QuarticAuthalic;
import gov.nasa.giss.mapping.proj.RaiszArmadillo;
import gov.nasa.giss.mapping.proj.Sinusoidal;
import gov.nasa.giss.mapping.proj.Stereographic;
import gov.nasa.giss.mapping.proj.VanDerGrinten1;
import gov.nasa.giss.mapping.proj.VerticalPerspective;
import gov.nasa.giss.mapping.proj.Wagner1;
import gov.nasa.giss.mapping.proj.Wagner2;
import gov.nasa.giss.mapping.proj.Wagner3;
import gov.nasa.giss.mapping.proj.Wagner4;
import gov.nasa.giss.mapping.proj.Wagner5;
import gov.nasa.giss.mapping.proj.Wagner6;
import gov.nasa.giss.mapping.proj.Wagner7;
import gov.nasa.giss.mapping.proj.Wagner8;
import gov.nasa.giss.mapping.proj.Wagner9;
import gov.nasa.giss.mapping.proj.Winkel1;
import gov.nasa.giss.mapping.proj.Winkel2;
import gov.nasa.giss.mapping.proj.WinkelTripel;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.TreeMap;

public class ProjectionFactory {
    private static final Class[] PROJECTIONS = new Class[]{Equirectangular.class, Orthographic.class, Mollweide.class, Stereographic.class, Aitoff.class, AzimEquidistant.class, AzimEqualarea.class, Hammer.class, Sinusoidal.class, Parabolic.class, Eckert4.class, Eckert6.class, Eckert5.class, EckertGreifendorff.class, QuarticAuthalic.class, FlatPolarQuartic.class, FlatPolarSinusoidal.class, FlatPolarParabolic.class, Eckert3.class, Wagner4.class, Kavraisky7.class, PutninsP3.class, PutninsP3p.class, PutninsP5.class, PutninsP5p.class, NellHammer.class, Wagner1.class, PutninsP4p.class, Winkel1.class, Wagner2.class, Wagner5.class, WinkelTripel.class, Mercator.class, MillerCylindrical.class, Gall.class, OrteliusOval.class, VanDerGrinten1.class, VerticalPerspective.class, Wagner7.class, Wagner8.class, ApianGlobular2.class, PutninsP1.class, PutninsP1p.class, Wagner6.class, Holzel.class, McBrydeThomasSine1.class, Kavraisky5.class, Denoyer.class, Winkel2.class, Wagner9.class, RaiszArmadillo.class, Wagner3.class};
    private static TreeMap projectionMap;

    private ProjectionFactory() {
    }

    public static AbstractProjection create(ProjectionID pid, int w, int h) {
        return ProjectionFactory.create(pid, w, h, 0, 0);
    }

    public static AbstractProjection create(ProjectionID pid, int w, int h, int xm, int ym) {
        if (pid == null) {
            throw new IllegalArgumentException("Null projection ID.");
        }
        try {
            Class aClass = pid.getPClass();
            Class[] types = new Class[]{Integer.class, Integer.class, Integer.class, Integer.class};
            Object[] args = new Object[]{new Integer(w), new Integer(h), new Integer(xm), new Integer(ym)};
            Constructor c = aClass.getConstructor(types);
            return (AbstractProjection)c.newInstance(args);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            throw new IllegalArgumentException("Projection construction error!");
        }
    }

    public static ProjectionID[] getList() {
        ProjectionID[] result = new ProjectionID[projectionMap.size()];
        int count = 0;
        Iterator it = projectionMap.entrySet().iterator();
        while (it.hasNext()) {
            result[count++] = (ProjectionID)it.next().getValue();
        }
        return result;
    }

    public static ProjectionID getID(String s) {
        if (s == null) {
            return null;
        }
        ProjectionID[] pids = ProjectionFactory.getList();
        for (int i = 0; i < pids.length; ++i) {
            if (!pids[i].getName().equals(s)) continue;
            return pids[i];
        }
        return null;
    }

    public static double getAspectRatio(ProjectionID pid) {
        if (pid == null) {
            throw new IllegalArgumentException("Null projection ID.");
        }
        try {
            Class[] types = new Class[]{};
            Object[] args = new Object[]{};
            Method theMethod = pid.getPClass().getMethod("getAspectRatio", types);
            return (Double)theMethod.invoke(null, args);
        }
        catch (Exception exc) {
            System.out.println("ERROR: Aspect ratio lookup failed: returning 0");
            return 0.0;
        }
    }

    public static boolean isAzimuthal(ProjectionID pid) {
        if (pid == null) {
            throw new IllegalArgumentException("Null projection ID.");
        }
        try {
            Class[] types = new Class[]{};
            Object[] args = new Object[]{};
            Method m = pid.getPClass().getMethod("isAzimuthal", types);
            return (Boolean)m.invoke(null, args);
        }
        catch (Exception exc) {
            System.out.println("ERROR: Azimuthal test failed: returning false");
            return false;
        }
    }

    public static boolean isAzimuthal(String pname) {
        return ProjectionFactory.isAzimuthal(ProjectionFactory.getID(pname));
    }

    static {
        Class[] types = new Class[]{};
        Object[] args = new Object[]{};
        projectionMap = new TreeMap();
        for (int i = 0; i < PROJECTIONS.length; ++i) {
            try {
                Method theMethod = PROJECTIONS[i].getMethod("getProjectionName", types);
                String s = (String)theMethod.invoke(null, args);
                projectionMap.put(s, new ProjectionID(s, PROJECTIONS[i]));
                continue;
            }
            catch (Exception exc) {
                System.out.println("ERROR: Couldn't set up projection " + i);
            }
        }
    }

    public static class ProjectionID {
        private String ppname;
        private Class ppclass;

        private ProjectionID(String s, Class c) {
            this.ppname = s;
            this.ppclass = c;
        }

        public String toString() {
            return this.getName();
        }

        public String getName() {
            return this.ppname;
        }

        private Class getPClass() {
            return this.ppclass;
        }
    }
}

