/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.ProjectionExtraParameter;

public class ProjectionDoubleParameter
extends ProjectionExtraParameter {
    private double value;
    private double defaultValue;
    private double min;
    private double max;
    private boolean minAllowed;
    private boolean maxAllowed;

    public ProjectionDoubleParameter(String s1, String s2, double d) {
        this(s1, s2, d, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, true, true);
    }

    public ProjectionDoubleParameter(String s1, String s2, double d, double d1, double d2) {
        this(s1, s2, d, d1, d2, true, true);
    }

    public ProjectionDoubleParameter(String s1, String s2, double d, double d1, double d2, boolean b1, boolean b2) {
        super(s1, s2);
        this.defaultValue = this.value = 0.0;
        this.min = Double.NEGATIVE_INFINITY;
        this.max = Double.POSITIVE_INFINITY;
        this.minAllowed = true;
        this.maxAllowed = true;
        this.min = d1;
        this.max = d2;
        this.minAllowed = b1;
        this.maxAllowed = b2;
        this.defaultValue = d;
        this.reset();
    }

    public void reset() {
        this.setValue(this.defaultValue);
    }

    public double getDefault() {
        return this.defaultValue;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double d) throws IllegalArgumentException {
        if (d < this.min) {
            throw new IllegalArgumentException("Value less than allowed minimum.");
        }
        if (d <= this.min && !this.minAllowed) {
            throw new IllegalArgumentException("Value must be greater than allowed minimum.");
        }
        if (d > this.max) {
            throw new IllegalArgumentException("Value greater than allowed maximum.");
        }
        if (d >= this.max && !this.maxAllowed) {
            throw new IllegalArgumentException("Value must be less than allowed maximum.");
        }
        this.value = d;
        if (this.parent != null) {
            this.parent.extraParameterChanged();
        }
    }
}

