/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.mapping.proj.QuadSymmetricProjection;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public abstract class PointPoleProjection
extends QuadSymmetricProjection {
    private Bezier[] curves = new Bezier[2];

    public void drawBorder(Graphics2D g2d) {
        if (this.borderStroke == null || this.foreground == null) {
            return;
        }
        g2d.setStroke(this.borderStroke);
        g2d.setColor(this.foreground);
        this.makeOuterBezier();
        this.curves[0].paint(g2d);
        this.curves[1].paint(g2d);
    }

    protected void makeOuterBezier() {
        double edgeLon = this.cop.x + 180.0 - 0.05;
        int np = 30;
        double fact = 3.0;
        Point2D.Double[] dotsE = new Point2D.Double[61];
        Point2D.Double[] dotsW = new Point2D.Double[61];
        for (int j = 0; j <= 30; ++j) {
            double jj = 3.0 * (double)j;
            Point2D.Double dot = this.transformLL2XY(edgeLon, jj);
            dotsE[30 - j] = new Point2D.Double(dot.x, dot.y);
            dotsE[30 + j] = new Point2D.Double(dot.x, 2.0 * (double)this.dstCenter.y - dot.y);
            dotsW[30 - j] = new Point2D.Double(2.0 * (double)this.dstCenter.x - dot.x, dot.y);
            dotsW[30 + j] = new Point2D.Double(2.0 * (double)this.dstCenter.x - dot.x, 2.0 * (double)this.dstCenter.y - dot.y);
        }
        this.curves[0] = new Bezier(false, dotsE);
        this.curves[1] = new Bezier(false, dotsW);
    }
}

