/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.PointPoleProjection;
import java.awt.geom.Point2D;

public class Parabolic
extends PointPoleProjection {
    private static final String PROJECTION_NAME = "Parabolic";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double SQRT3PI = Math.sqrt(Math.PI * 3);
    private static final double SQRT3OVERPI = Math.sqrt(0.954929658551372);
    private static final double WIDTH_FACTOR = SQRT3PI;
    private static final double HEIGHT_FACTOR = 0.5 * SQRT3PI;
    private static final double ASPECT_RATIO = WIDTH_FACTOR / HEIGHT_FACTOR;

    public Parabolic(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public Parabolic(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public Parabolic(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, WIDTH_FACTOR, HEIGHT_FACTOR, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    protected void calculateInverseArray() {
        double y;
        double phiRad;
        double phi;
        this.clearInverseArray();
        double rSSqrt3OverPi = this.rS * SQRT3OVERPI;
        double oneOverRSSqrt3Pi = 1.0 / (this.rS * SQRT3PI);
        for (int iy = 0; iy < this.dstMax.y && !((phi = Parabolic.toDegrees(phiRad = 3.0 * Math.asin((y = (double)iy + 0.5) * oneOverRSSqrt3Pi))) > 90.0); ++iy) {
            double xFactor = 1.0 / (rSSqrt3OverPi * (2.0 * Math.cos(2.0 * phiRad / 3.0) - 1.0));
            for (int ix = 0; ix < this.dstMax.x; ++ix) {
                double x = (double)ix + 0.5;
                double lambda = Parabolic.toDegrees(x * xFactor);
                if (lambda > 180.0) continue;
                this.setQSymmetricPoints(ix, iy, lambda, phi);
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRadOver3 = Parabolic.toRadians(lat) / 3.0;
        double x = SQRT3OVERPI * this.transformLon2LambdaRad(lon) * (2.0 * Math.cos(2.0 * phiRadOver3) - 1.0);
        double y = SQRT3PI * Math.sin(phiRadOver3);
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

