/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.FlatPoleProjection;
import java.awt.geom.Point2D;

public class NellHammer
extends FlatPoleProjection {
    private static final String PROJECTION_NAME = "Nell-Hammer";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = 1.1415926535897931;
    private static final double ASPECT_RATIO = 2.751938393884109;

    public NellHammer(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public NellHammer(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public NellHammer(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, Math.PI, 1.1415926535897931, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return 2.751938393884109;
    }

    protected void calculateInverseArray() {
        this.clearInverseArray();
        double twoOverRS = 2.0 * this.oneOverRS;
        double oneOver2RS = 0.5 * this.oneOverRS;
        double phiRad = 0.0;
        for (int iy = 0; iy < this.dstMax.y; ++iy) {
            double y = (double)iy + 0.5;
            double yOver2RS = y * oneOver2RS;
            for (int i = 0; i < 12; ++i) {
                double halfPhiRad = 0.5 * phiRad;
                double cosHalfPhi = Math.cos(halfPhiRad);
                double dphiRad = (phiRad - Math.tan(halfPhiRad) - yOver2RS) / (1.0 - 0.5 / (cosHalfPhi * cosHalfPhi));
                phiRad -= dphiRad;
                if (Math.abs(dphiRad) < 1.0E-5) break;
            }
            if (phiRad > 1.5707963267948966) break;
            double xFactor = twoOverRS / (1.0 + Math.cos(phiRad));
            for (int ix = 0; ix < this.dstMax.x; ++ix) {
                double x = (double)ix + 0.5;
                double lambdaRad = x * xFactor;
                if (lambdaRad > Math.PI) continue;
                this.setQSymmetricPoints(ix, iy, NellHammer.toDegrees(lambdaRad), NellHammer.toDegrees(phiRad));
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = NellHammer.toRadians(lat);
        double x = 0.5 * this.transformLon2LambdaRad(lon) * (1.0 + Math.cos(phiRad));
        double y = 2.0 * (phiRad - Math.tan(0.5 * phiRad));
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

