/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.CurvePoleProjection;
import java.awt.geom.Point2D;

public class Mollweide
extends CurvePoleProjection {
    private static final String PROJECTION_NAME = "Mollweide";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double WIDTH_FACTOR = 2.0 * SQRT2;
    private static final double HEIGHT_FACTOR = SQRT2;
    private static final double ASPECT_RATIO = WIDTH_FACTOR / HEIGHT_FACTOR;

    public Mollweide(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public Mollweide(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public Mollweide(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, WIDTH_FACTOR, HEIGHT_FACTOR, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    protected void calculateInverseArray() {
        double y;
        double thetaRad;
        double phiRad;
        this.clearInverseArray();
        double oneOverSqrt2RS = this.oneOverRS / SQRT2;
        double piOver2RSSqrt2 = 1.5707963267948966 * this.oneOverRS / SQRT2;
        for (int iy = 0; iy < this.dstMax.y && !((phiRad = Math.asin((2.0 * (thetaRad = Math.asin((y = (double)iy + 0.5) * oneOverSqrt2RS)) + Math.sin(2.0 * thetaRad)) * 0.3183098861837907)) > 1.5707963267948966); ++iy) {
            double phi = Mollweide.toDegrees(phiRad);
            double xFactor = piOver2RSSqrt2 / Math.cos(thetaRad);
            for (int ix = 0; ix < this.dstMax.x; ++ix) {
                double x = (double)ix + 0.5;
                double lambdaRad = x * xFactor;
                if (lambdaRad > Math.PI) continue;
                this.setQSymmetricPoints(ix, iy, Mollweide.toDegrees(lambdaRad), phi);
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        if (lat == 90.0) {
            return new Point2D.Double(this.dstCenter.x, (double)this.dstCenter.y - SQRT2 * this.rS);
        }
        if (lat == -90.0) {
            return new Point2D.Double(this.dstCenter.x, (double)this.dstCenter.y + SQRT2 * this.rS);
        }
        double piSinPhi = Math.PI * Math.sin(Mollweide.toRadians(lat));
        double thetaRad = Mollweide.toRadians(lat);
        for (int i = 0; i < 25; ++i) {
            double twoThetaRad = 2.0 * thetaRad;
            double dthetaRad = 0.5 * (piSinPhi - twoThetaRad - Math.sin(twoThetaRad)) / (1.0 + Math.cos(twoThetaRad));
            thetaRad += dthetaRad;
            if (Math.abs(dthetaRad) < 1.0E-5) break;
        }
        double x = SQRT2 / 1.5707963267948966 * this.transformLon2LambdaRad(lon) * Math.cos(thetaRad);
        double y = SQRT2 * Math.sin(thetaRad);
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

