/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.RectangleProjection;
import java.awt.geom.Point2D;

public class MillerCylindrical
extends RectangleProjection {
    private static final String PROJECTION_NAME = "Miller Cylindrical";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = Math.log(Math.tan(MillerCylindrical.toRadians(81.0)));
    private static final double ASPECT_RATIO = Math.PI / HEIGHT_FACTOR;

    public MillerCylindrical(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public MillerCylindrical(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public MillerCylindrical(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, Math.PI, HEIGHT_FACTOR, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    protected void calculateInverseArray() {
        double y;
        double aterm;
        double phi;
        this.clearInverseArray();
        for (int iy = 0; iy < this.dstMax.y && !((phi = 1.25 * MillerCylindrical.toDegrees(2.0 * (aterm = Math.atan(Math.exp((y = (double)iy + 0.5) * this.oneOverRS))) - 1.5707963267948966)) > 90.0); ++iy) {
            double x;
            double lambda;
            for (int ix = 0; ix < this.dstMax.x && !((lambda = MillerCylindrical.toDegrees((x = (double)ix + 0.5) * this.oneOverRS)) > 180.0); ++ix) {
                this.setQSymmetricPoints(ix, iy, lambda, phi);
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double x = this.transformLon2LambdaRad(lon);
        double y = Math.log(Math.tan(0.5 * (1.5707963267948966 + 0.8 * MillerCylindrical.toRadians(lat))));
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

