/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.ProjectionDoubleParameter;
import gov.nasa.giss.mapping.proj.ProjectionExtraParameter;
import gov.nasa.giss.mapping.proj.RectangleProjection;
import java.awt.geom.Point2D;

public class Mercator
extends RectangleProjection {
    private static final String PROJECTION_NAME = "Mercator";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double DEFAULT_MAXLAT = 80.0;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = Math.log(Math.tan(Mercator.toRadians(85.0)));
    private static final double ASPECT_RATIO = Math.PI / HEIGHT_FACTOR;
    public double maxLat = 80.0;

    public Mercator(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public Mercator(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public Mercator(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, Math.PI, HEIGHT_FACTOR, dw, dh, xm, ym);
        this.setExtraParameters(new ProjectionExtraParameter[]{new ProjectionDoubleParameter("Max. Latitude", "\u00b0", 80.0, 45.0, 90.0, true, false)});
        this.extraParameterChanged();
    }

    public void extraParameterChanged() {
        ProjectionDoubleParameter p = (ProjectionDoubleParameter)this.getParameter(1);
        this.maxLat = p.getValue();
        this.fitToTarget();
        this.needsUpdate = true;
    }

    protected void fitToTarget() {
        this.heightFactor = Math.log(Math.tan(Mercator.toRadians(45.0 + 0.5 * this.maxLat)));
        super.fitToTarget();
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    protected void calculateInverseArray() {
        double y;
        double phi;
        this.clearInverseArray();
        for (int iy = 0; iy < this.dstMax.y && !((phi = Mercator.toDegrees(2.0 * Math.atan(Math.exp((y = (double)iy + 0.5) * this.oneOverRS)) - 1.5707963267948966)) > this.maxLat); ++iy) {
            double x;
            double lambda;
            for (int ix = 0; ix < this.dstMax.x && !((lambda = Mercator.toDegrees((x = (double)ix + 0.5) * this.oneOverRS)) > 180.0); ++ix) {
                this.setQSymmetricPoints(ix, iy, lambda, phi);
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > this.maxLat) {
            return null;
        }
        double x = this.transformLon2LambdaRad(lon);
        double y = Math.log(Math.tan(0.5 * (1.5707963267948966 + Math.toRadians(lat))));
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

