/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.PointPoleProjection;
import java.awt.geom.Point2D;

public class McBrydeThomasSine1
extends PointPoleProjection {
    private static final String PROJECTION_NAME = "McBryde-Thomas Sine #1";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double TERM_Q = 1.36509;
    private static final double TERM_P = 1.48875;
    private static final double Q_OVER_P = 0.9169370277078085;
    private static final double P_OVER_Q = 1.090587433795574;
    private static final double WIDTH_FACTOR = 2.880642630051312;
    private static final double HEIGHT_FACTOR = 1.48875 * Math.sin(1.1506906700619715);
    private static final double ASPECT_RATIO = 2.880642630051312 / HEIGHT_FACTOR;

    public McBrydeThomasSine1(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public McBrydeThomasSine1(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public McBrydeThomasSine1(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, 2.880642630051312, HEIGHT_FACTOR, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    protected void calculateInverseArray() {
        double y;
        double phiRad;
        double phi;
        this.clearInverseArray();
        double oneOverPRS = this.oneOverRS / 1.48875;
        for (int iy = 0; iy < this.dstMax.y && !((phi = McBrydeThomasSine1.toDegrees(phiRad = 1.36509 * Math.asin((y = (double)iy + 0.5) * oneOverPRS))) > 90.0); ++iy) {
            double x;
            double lambda;
            double xFactor = this.oneOverRS * 1.090587433795574 * Math.cos(phiRad / 1.36509) / Math.cos(phiRad);
            for (int ix = 0; ix < this.dstMax.x && !((lambda = McBrydeThomasSine1.toDegrees((x = (double)ix + 0.5) * xFactor)) > 180.0); ++ix) {
                this.setQSymmetricPoints(ix, iy, lambda, phi);
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double phiRad = McBrydeThomasSine1.toRadians(lat);
        double phiOverQ = phiRad / 1.36509;
        double x = 0.9169370277078085 * this.transformLon2LambdaRad(lon) * Math.cos(phiRad) / Math.cos(phiOverQ);
        double y = 1.48875 * Math.sin(phiOverQ);
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

