/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.mapping.proj;

import gov.nasa.giss.mapping.proj.FlatPoleProjection;
import java.awt.geom.Point2D;

public class McBrydeS3
extends FlatPoleProjection {
    private static final String PROJECTION_NAME = "McBryde S3";
    private static final boolean IS_AZIMUTHAL = false;
    private static final double JOIN_LAT = 55.85;
    private static final double YSHIFT = 0.069065;
    private static final double QUARTER_PI = 0.7853981633974483;
    private static final double TERM_C = Math.sqrt(0.840148730267336);
    private static final double TERM_D = 1.7853981633974483;
    private static final double WIDTH_FACTOR = Math.PI;
    private static final double HEIGHT_FACTOR = TERM_C * 1.5707963267948966 - 0.069065;
    private static final double ASPECT_RATIO = Math.PI / HEIGHT_FACTOR;

    public McBrydeS3(int dw, int dh) {
        this(dw, dh, 0, 0);
    }

    public McBrydeS3(Integer dw, Integer dh, Integer xm, Integer ym) {
        this((int)dw, (int)dh, (int)xm, (int)ym);
    }

    public McBrydeS3(int dw, int dh, int xm, int ym) {
        this.init(PROJECTION_NAME, false, Math.PI, HEIGHT_FACTOR, dw, dh, xm, ym);
    }

    public static String getProjectionName() {
        return PROJECTION_NAME;
    }

    public static boolean isAzimuthal() {
        return false;
    }

    public static double getAspectRatio() {
        return ASPECT_RATIO;
    }

    protected void calculateInverseArray() {
        this.clearInverseArray();
        Point2D.Double joinPt = this.transformLL2XY(0.0, 55.85);
        double joinY = (double)this.dstCenter.y - joinPt.y;
        double termE = this.oneOverRS * 1.5 / TERM_C;
        for (int iy = 0; iy < this.dstMax.y; ++iy) {
            double x;
            double lambda;
            double xFactor;
            double phi;
            double y = (double)iy + 0.5;
            if (y > joinY) {
                double thetaRad = (y += 0.069065 * this.rS) * this.oneOverRS / TERM_C;
                double sinTheta = Math.sin(thetaRad);
                phi = McBrydeS3.toDegrees(Math.asin((0.5 * thetaRad + sinTheta) / 1.7853981633974483));
                xFactor = termE / (0.5 + Math.cos(thetaRad));
            } else {
                double phiRad = y * this.oneOverRS;
                phi = McBrydeS3.toDegrees(phiRad);
                xFactor = this.oneOverRS / Math.cos(phiRad);
            }
            if (phi > 90.0) break;
            for (int ix = 0; ix < this.dstMax.x && !((lambda = McBrydeS3.toDegrees((x = (double)ix + 0.5) * xFactor)) > 180.0); ++ix) {
                this.setQSymmetricPoints(ix, iy, lambda, phi);
            }
        }
        this.needsUpdate = false;
    }

    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            return null;
        }
        double x = this.transformLon2LambdaRad(lon);
        double y = 1.0;
        if (Math.abs(lat) > 55.85) {
            double phiFactor = 1.7853981633974483 * Math.sin(McBrydeS3.toRadians(lat));
            double thetaRad = McBrydeS3.toRadians(lat);
            for (int i = 0; i < 25; ++i) {
                double sinTheta = Math.sin(thetaRad);
                double cosTheta = Math.cos(thetaRad);
                double dthetaRad = -(0.5 * thetaRad + sinTheta - phiFactor) / (0.5 + cosTheta);
                thetaRad += dthetaRad;
                if (Math.abs(dthetaRad) < 1.0E-5) break;
            }
            x *= TERM_C * (0.5 + Math.cos(thetaRad)) / 1.5;
            y = lat > 0.0 ? (y *= TERM_C * thetaRad - 0.069065) : (y *= TERM_C * thetaRad + 0.069065);
        } else {
            double phiRad = McBrydeS3.toRadians(lat);
            x *= Math.cos(phiRad);
            y *= phiRad;
        }
        return new Point2D.Double((double)this.dstCenter.x + x * this.rS, (double)this.dstCenter.y - y * this.rS);
    }
}

